
package org.mule.modules.drupal.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.drupal.model.holders.FileExpressionHolder;
import org.mule.modules.drupal.processors.CreateFileMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser.ParseDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.6.1", date = "2016-01-21T09:59:19-03:00", comments = "Build UNNAMED.2405.44720b7")
public class CreateFileDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(CreateFileDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(CreateFileMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [create-file] within the connector [drupal] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [create-file] within the connector [drupal] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("createFile");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        if (!hasAttribute(element, "config-ref")) {
            throw new BeanDefinitionParsingException(new Problem("It seems that the config-ref for @Processor [create-file] within the connector [drupal] is null or missing. Please, fill the value with the correct global element.", new Location(parserContext.getReaderContext().getResource()), null));
        }
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "file", "file", "#[payload]")) {
            BeanDefinitionBuilder fileBuilder = BeanDefinitionBuilder.rootBeanDefinition(FileExpressionHolder.class.getName());
            Element fileChildElement = DomUtils.getChildElementByTagName(element, "file");
            if (fileChildElement!= null) {
                parseProperty(fileBuilder, fileChildElement, "serialVersionUID", "serialVersionUID");
                if (hasAttribute(fileChildElement, "rdfMapping-ref")) {
                    if (fileChildElement.getAttribute("rdfMapping-ref").startsWith("#")) {
                        fileBuilder.addPropertyValue("rdfMapping", fileChildElement.getAttribute("rdfMapping-ref"));
                    } else {
                        fileBuilder.addPropertyValue("rdfMapping", (("#[registry:"+ fileChildElement.getAttribute("rdfMapping-ref"))+"]"));
                    }
                }
                parseProperty(fileBuilder, fileChildElement, "uri", "uri");
                parseMapAndSetProperty(fileChildElement, fileBuilder, "customFields", "custom-fields", "custom-field", new ParseDelegate<String>() {


                    public String parse(Element element) {
                        return element.getTextContent();
                    }

                }
                );
                parseProperty(fileBuilder, fileChildElement, "fid", "fid");
                parseProperty(fileBuilder, fileChildElement, "uid", "uid");
                parseProperty(fileBuilder, fileChildElement, "filename", "filename");
                parseProperty(fileBuilder, fileChildElement, "filemime", "filemime");
                parseProperty(fileBuilder, fileChildElement, "filesize", "filesize");
                parseProperty(fileBuilder, fileChildElement, "status", "status");
                parseProperty(fileBuilder, fileChildElement, "timestamp", "timestamp");
                parseProperty(fileBuilder, fileChildElement, "content", "content");
                parseProperty(fileBuilder, fileChildElement, "uriFull", "uriFull");
                parseProperty(fileBuilder, fileChildElement, "targetUri", "targetUri");
                if (hasAttribute(fileChildElement, "imageStyles-ref")) {
                    if (fileChildElement.getAttribute("imageStyles-ref").startsWith("#")) {
                        fileBuilder.addPropertyValue("imageStyles", fileChildElement.getAttribute("imageStyles-ref"));
                    } else {
                        fileBuilder.addPropertyValue("imageStyles", (("#[registry:"+ fileChildElement.getAttribute("imageStyles-ref"))+"]"));
                    }
                }
                builder.addPropertyValue("file", fileBuilder.getBeanDefinition());
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
