/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.drupal.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.drupal.adapters.DrupalConnectorConnectionIdentifierAdapter;
import org.mule.modules.drupal.connectivity.DrupalConnectorConnectionKey;
import org.mule.modules.drupal.connectivity.DrupalConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrupalConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(DrupalConnectorConnectionFactory.class);
    private DrupalConnectorConnectionManager connectionManager;

    public DrupalConnectorConnectionFactory(DrupalConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof DrupalConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.drupal.connectivity.DrupalConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        DrupalConnectorConnectionIdentifierAdapter connector = new DrupalConnectorConnectionIdentifierAdapter();
        connector.setServer(this.connectionManager.getServer());
        connector.setApiUrl(this.connectionManager.getApiUrl());
        connector.setPort(this.connectionManager.getPort());
        connector.setUserEndpoint(this.connectionManager.getUserEndpoint());
        connector.setNodeEndpoint(this.connectionManager.getNodeEndpoint());
        connector.setCommentEndpoint(this.connectionManager.getCommentEndpoint());
        connector.setFileEndpoint(this.connectionManager.getFileEndpoint());
        connector.setTaxonomyTermEndpoint(this.connectionManager.getTaxonomyTermEndpoint());
        connector.setTaxonomyVocabularyEndpoint(this.connectionManager.getTaxonomyVocabularyEndpoint());
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.isConnected()) {
            connector.connect(((DrupalConnectorConnectionKey)key).getUsername(), ((DrupalConnectorConnectionKey)key).getPassword());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof DrupalConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.drupal.connectivity.DrupalConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof DrupalConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.drupal.adapters.DrupalConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((DrupalConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((DrupalConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((DrupalConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof DrupalConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.drupal.adapters.DrupalConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((DrupalConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof DrupalConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof DrupalConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((DrupalConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((DrupalConnectorConnectionIdentifierAdapter)obj).connect(((DrupalConnectorConnectionKey)key).getUsername(), ((DrupalConnectorConnectionKey)key).getPassword());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

