/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.drupal.config;

import org.mule.config.PoolingProfile;
import org.mule.modules.drupal.config.AbstractDefinitionParser;
import org.mule.modules.drupal.connectivity.DrupalConnectorConnectionManager;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class DrupalConnectorConfigDefinitionParser
extends AbstractDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.parseConfigName(element);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)DrupalConnectorConnectionManager.class.getName());
        builder.setScope("singleton");
        this.setInitMethodIfNeeded(builder, DrupalConnectorConnectionManager.class);
        this.setDestroyMethodIfNeeded(builder, DrupalConnectorConnectionManager.class);
        this.parseProperty(builder, element, "server", "server");
        this.parseProperty(builder, element, "apiUrl", "apiUrl");
        this.parseProperty(builder, element, "port", "port");
        this.parseProperty(builder, element, "userEndpoint", "userEndpoint");
        this.parseProperty(builder, element, "nodeEndpoint", "nodeEndpoint");
        this.parseProperty(builder, element, "commentEndpoint", "commentEndpoint");
        this.parseProperty(builder, element, "fileEndpoint", "fileEndpoint");
        this.parseProperty(builder, element, "taxonomyTermEndpoint", "taxonomyTermEndpoint");
        this.parseProperty(builder, element, "taxonomyVocabularyEndpoint", "taxonomyVocabularyEndpoint");
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        BeanDefinitionBuilder connectionPoolingProfileBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)PoolingProfile.class.getName());
        Element connectionPoolingProfileElement = DomUtils.getChildElementByTagName((Element)element, (String)"connection-pooling-profile");
        if (connectionPoolingProfileElement != null) {
            this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "maxActive");
            this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "maxIdle");
            this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "maxWait");
            if (this.hasAttribute(connectionPoolingProfileElement, "exhaustedAction")) {
                connectionPoolingProfileBuilder.addPropertyValue("exhaustedAction", PoolingProfile.POOL_EXHAUSTED_ACTIONS.get(connectionPoolingProfileElement.getAttribute("exhaustedAction")));
            }
            if (this.hasAttribute(connectionPoolingProfileElement, "initialisationPolicy")) {
                connectionPoolingProfileBuilder.addPropertyValue("initialisationPolicy", PoolingProfile.POOL_INITIALISATION_POLICIES.get(connectionPoolingProfileElement.getAttribute("initialisationPolicy")));
            }
            if (this.hasAttribute(connectionPoolingProfileElement, "evictionCheckIntervalMillis")) {
                this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "evictionCheckIntervalMillis");
            }
            if (this.hasAttribute(connectionPoolingProfileElement, "minEvictionMillis")) {
                this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "minEvictionMillis");
            }
            builder.addPropertyValue("connectionPoolingProfile", (Object)connectionPoolingProfileBuilder.getBeanDefinition());
        }
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect", element, parserContext, builder, (BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect-forever", element, parserContext, builder, (BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect-custom-strategy", element, parserContext, builder, (BeanDefinition)definition);
        return definition;
    }
}

