/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.drupal.client;

import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import org.apache.commons.lang.StringUtils;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.modules.drupal.DrupalCollection;
import org.mule.modules.drupal.GsonFactory;
import org.mule.modules.drupal.client.DrupalClient;
import org.mule.modules.drupal.client.DrupalException;
import org.mule.modules.drupal.model.Comment;
import org.mule.modules.drupal.model.CommentRequest;
import org.mule.modules.drupal.model.CountRequest;
import org.mule.modules.drupal.model.DrupalEntity;
import org.mule.modules.drupal.model.File;
import org.mule.modules.drupal.model.Node;
import org.mule.modules.drupal.model.NodeRequest;
import org.mule.modules.drupal.model.TaxonomyTerm;
import org.mule.modules.drupal.model.TaxonomyVocabulary;
import org.mule.modules.drupal.model.TaxonomyVocabularyRequest;
import org.mule.modules.drupal.model.User;

public class DrupalRestClient
implements DrupalClient {
    private Client client = Client.create();
    private String server;
    private String apiUrl;
    private int port;
    private NewCookie sessionId;
    private static final String RELATIONSHIP_FILES = "files";
    private static final String RELATIONSHIP_COMMENTS = "comments";
    private static final String COUNT_ALL = "countAll";
    private static final String COUNT_NEW = "countNew";
    private static final String REGISTER = "register";
    private static final String LOGIN = "login";
    private static final String LOGOUT = "logout";
    private static final String ACTION_GETTREE = "getTree";
    private static final String ACTION_SELECTNODES = "selectNodes";
    private String username;
    private String password;

    public DrupalRestClient(String server, int port, String apiUrl) {
        this.server = server;
        this.apiUrl = apiUrl;
        this.port = port;
    }

    public Client getClient() {
        if (this.client == null) {
            this.client = Client.create();
        }
        return this.client;
    }

    private WebResource getWebResource() throws DrupalException {
        WebResource r;
        try {
            r = this.client.resource(new URI("http", null, this.server, this.port, this.apiUrl, null, null));
        }
        catch (URISyntaxException e) {
            throw new DrupalException(e);
        }
        return r;
    }

    @Override
    public Node readNode(String nodeId) throws DrupalException {
        Node node = null;
        node = (Node)this.readOne(DrupalCollection.Node, nodeId);
        return node;
    }

    @Override
    public void login(String username, String password) throws ConnectionException {
        WebResource r;
        HashMap<String, String> loginCredentials = new HashMap<String, String>();
        loginCredentials.put("username", username);
        loginCredentials.put("password", password);
        this.username = username;
        this.password = password;
        String request = GsonFactory.getGson().toJson(loginCredentials);
        try {
            r = this.client.resource(new URI("http", null, this.server, this.port, this.apiUrl + "/" + DrupalCollection.User.getEndpoint() + "/" + LOGIN, null, null));
        }
        catch (URISyntaxException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, null);
        }
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).entity((Object)request, MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class);
        ClientResponse.Status status = response.getClientResponseStatus();
        if (status == ClientResponse.Status.OK) {
            String entity = (String)response.getEntity(String.class);
            if (response.getCookies().isEmpty()) {
                throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, entity, "Drupal rejected login");
            }
        } else {
            if (status == ClientResponse.Status.UNAUTHORIZED) {
                throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, null, null);
            }
            throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, null, null);
        }
        this.sessionId = (NewCookie)response.getCookies().get(0);
    }

    public DrupalEntity create(DrupalCollection collection, DrupalEntity entity) throws DrupalException {
        Object response = this.executeRequest("POST", this.getWebResource().path(collection.getEndpoint()), collection, entity);
        return response;
    }

    public DrupalEntity readOne(DrupalCollection collection, String objectId) throws DrupalException {
        Object response = this.executeRequest("GET", this.getWebResource().path(collection.getEndpoint()).path(objectId), collection, null);
        return response;
    }

    public DrupalEntity update(DrupalCollection collection, String objectId, DrupalEntity entity) throws DrupalException {
        Object response = this.executeRequest("PUT", this.getWebResource().path(collection.getEndpoint()).path(objectId), collection, entity);
        return response;
    }

    private <T> List<T> executeListRequest(String method, WebResource r, Type listType, Map<String, String> params) throws DrupalException {
        ClientResponse response;
        ClientResponse.Status status;
        WebResource.Builder builder = (WebResource.Builder)r.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).cookie((Cookie)this.sessionId);
        if (params != null) {
            String request = GsonFactory.getGson().toJson(params);
            builder = (WebResource.Builder)builder.entity((Object)request, "application/json");
        }
        if ((status = (response = (ClientResponse)builder.method(method, ClientResponse.class)).getClientResponseStatus()) == ClientResponse.Status.OK) {
            String json = (String)response.getEntity(String.class);
            List apiResponse = (List)GsonFactory.getGson().fromJson(json, listType);
            return apiResponse;
        }
        if (status == ClientResponse.Status.UNAUTHORIZED) {
            throw new DrupalException("Drupal returned " + status.getStatusCode());
        }
        throw new DrupalException(String.format("API returned status code %d, 200 was expected." + status.getReasonPhrase(), status.getStatusCode()));
    }

    private <T extends DrupalEntity> T executeRequest(String method, WebResource r, DrupalCollection dc, Object entity) throws DrupalException {
        WebResource.Builder builder = (WebResource.Builder)r.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).cookie((Cookie)this.sessionId);
        if (entity instanceof DrupalEntity) {
            builder = (WebResource.Builder)builder.entity((Object)GsonFactory.getGson().toJson(entity, DrupalEntity.class), MediaType.APPLICATION_JSON_TYPE);
        } else if (entity != null) {
            builder = (WebResource.Builder)builder.entity(entity, MediaType.APPLICATION_JSON_TYPE);
        }
        ClientResponse response = (ClientResponse)builder.method(method, ClientResponse.class);
        ClientResponse.Status status = response.getClientResponseStatus();
        if (status == ClientResponse.Status.OK) {
            String json = (String)response.getEntity(String.class);
            T apiResponse = null;
            apiResponse = this.handleResultStatusOK(dc, entity, json, apiResponse);
            return apiResponse;
        }
        if (status == ClientResponse.Status.UNAUTHORIZED) {
            throw new DrupalException("Drupal returned " + status.getStatusCode());
        }
        throw new DrupalException(String.format("API returned status code %d, 200 was expected. Reason:%s", status.getStatusCode(), status.getReasonPhrase()));
    }

    private <T extends DrupalEntity> T handleResultStatusOK(DrupalCollection dc, Object entity, String json, T apiResponse) throws DrupalException {
        if (dc != null && !(entity instanceof TaxonomyTerm) && !(entity instanceof TaxonomyVocabulary)) {
            try {
                apiResponse = (DrupalEntity)GsonFactory.getGson().fromJson(json, dc.getType());
                DrupalEntity tempEntity = (DrupalEntity)GsonFactory.getGson().fromJson(json, DrupalEntity.class);
                ((DrupalEntity)apiResponse).setCustomFields(tempEntity.getCustomFields());
            }
            catch (JsonSyntaxException js) {
                throw new DrupalException("Error processing Json :" + js.getMessage());
            }
        }
        return (T)apiResponse;
    }

    @Override
    public Comment readComment(String commentId) throws DrupalException {
        Comment comment = null;
        comment = (Comment)this.readOne(DrupalCollection.Comment, commentId);
        return comment;
    }

    @Override
    public User readUser(String userId) throws DrupalException {
        User user = null;
        user = (User)this.readOne(DrupalCollection.User, userId);
        return user;
    }

    @Override
    public TaxonomyTerm readTaxonomyTerm(String taxonomyTermId) throws DrupalException {
        TaxonomyTerm taxonomyTerm = null;
        taxonomyTerm = (TaxonomyTerm)this.readOne(DrupalCollection.TaxonomyTerm, taxonomyTermId);
        return taxonomyTerm;
    }

    @Override
    public File readFile(String fileId) throws DrupalException {
        File file = null;
        file = (File)this.readOne(DrupalCollection.File, fileId);
        return file;
    }

    @Override
    public TaxonomyVocabulary readTaxonomyVocabulary(String taxonomyVocabularyId) throws DrupalException {
        TaxonomyVocabulary taxonomyVoc = null;
        taxonomyVoc = (TaxonomyVocabulary)this.readOne(DrupalCollection.TaxonomyVocabulary, taxonomyVocabularyId);
        return taxonomyVoc;
    }

    @Override
    public Node createNode(Node node) throws DrupalException {
        NodeRequest n = new NodeRequest();
        n.setNode(node);
        Node createdNode = (Node)this.create(DrupalCollection.Node, n);
        node.setNid(createdNode.getNid());
        return node;
    }

    @Override
    public Comment createComment(Comment comment) throws DrupalException {
        CommentRequest c = new CommentRequest();
        c.setComment(comment);
        Comment createdComment = (Comment)this.create(DrupalCollection.Comment, c);
        comment.setCid(createdComment.getCid());
        return comment;
    }

    @Override
    public User createUser(User user) throws DrupalException {
        User createdUser = (User)this.create(DrupalCollection.User, user);
        user.setUid(createdUser.getUid());
        return user;
    }

    @Override
    public TaxonomyTerm createTaxonomyTerm(TaxonomyTerm taxonomyTerm) throws DrupalException {
        TaxonomyTerm createdTV = (TaxonomyTerm)this.create(DrupalCollection.TaxonomyTerm, taxonomyTerm);
        if (createdTV != null) {
            taxonomyTerm.setVid(createdTV.getVid());
        }
        return taxonomyTerm;
    }

    @Override
    public File createFile(File file) throws DrupalException {
        File createdFile = (File)this.create(DrupalCollection.File, file);
        file.setFid(createdFile.getFid());
        return file;
    }

    @Override
    public TaxonomyVocabulary createTaxonomyVocabulary(TaxonomyVocabulary taxonomyVocabulary) throws DrupalException {
        TaxonomyVocabularyRequest rtv = new TaxonomyVocabularyRequest();
        ArrayList<TaxonomyVocabulary> list = new ArrayList<TaxonomyVocabulary>();
        list.add(taxonomyVocabulary);
        rtv.setVocabulary(list);
        TaxonomyVocabulary createdTV = (TaxonomyVocabulary)this.create(DrupalCollection.TaxonomyVocabulary, taxonomyVocabulary);
        if (createdTV != null) {
            taxonomyVocabulary.setVid(createdTV.getVid());
        }
        return taxonomyVocabulary;
    }

    @Override
    public void logout() throws ConnectionException {
        WebResource r;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", this.username);
        params.put("password", this.password);
        String request = GsonFactory.getGson().toJson(params);
        try {
            r = this.client.resource(new URI("http", null, this.server, this.port, this.apiUrl + "/" + DrupalCollection.User.getEndpoint() + "/" + LOGOUT, null, null));
        }
        catch (URISyntaxException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, null);
        }
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)r.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).entity((Object)request, MediaType.APPLICATION_JSON_TYPE)).cookie((Cookie)this.sessionId)).post(ClientResponse.class);
        ClientResponse.Status status = response.getClientResponseStatus();
        if (status != ClientResponse.Status.OK) {
            if (status == ClientResponse.Status.UNAUTHORIZED) {
                throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, null, null);
            }
            throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, null, null);
        }
        this.client = null;
        this.sessionId = null;
    }

    @Override
    public boolean isConnected() {
        return this.client != null && this.sessionId != null && this.sessionId.getValue() != null;
    }

    @Override
    public void deleteNode(int nodeId) throws DrupalException {
        this.deleteOne(DrupalCollection.Node, nodeId);
    }

    @Override
    public void deleteComment(int commentId) throws DrupalException {
        this.deleteOne(DrupalCollection.Comment, commentId);
    }

    private DrupalEntity deleteOne(DrupalCollection collection, int objectId) throws DrupalException {
        Object response = this.executeRequest("DELETE", this.getWebResource().path(collection.getEndpoint()).path(String.valueOf(objectId)), null, null);
        return response;
    }

    @Override
    public void deleteTaxonomyVocabulary(int taxonomyVocId) throws DrupalException {
        this.deleteOne(DrupalCollection.TaxonomyVocabulary, taxonomyVocId);
    }

    @Override
    public void deleteTaxonomyTerm(int taxonomyTermId) throws DrupalException {
        this.deleteOne(DrupalCollection.TaxonomyTerm, taxonomyTermId);
    }

    @Override
    public void deleteFile(int fileId) throws DrupalException {
        this.deleteOne(DrupalCollection.File, fileId);
    }

    @Override
    public void deleteUser(int userId) throws DrupalException {
        this.deleteOne(DrupalCollection.User, userId);
    }

    @Override
    public Node updateNode(Node node) throws DrupalException {
        node = (Node)this.update(DrupalCollection.Node, node.getNid().toString(), node);
        return node;
    }

    @Override
    public Comment updateComment(Comment comment) throws DrupalException {
        comment = (Comment)this.update(DrupalCollection.Comment, comment.getCid().toString(), comment);
        return comment;
    }

    @Override
    public User updateUser(User user) throws DrupalException {
        user = (User)this.update(DrupalCollection.User, user.getUid().toString(), user);
        return user;
    }

    @Override
    public TaxonomyTerm updateTaxonomyTerm(TaxonomyTerm taxonomyTerm) throws DrupalException {
        taxonomyTerm = (TaxonomyTerm)this.update(DrupalCollection.TaxonomyTerm, taxonomyTerm.getTid().toString(), taxonomyTerm);
        return taxonomyTerm;
    }

    @Override
    public File updateFile(File file) throws DrupalException {
        file = (File)this.update(DrupalCollection.File, file.getFid().toString(), file);
        return file;
    }

    @Override
    public TaxonomyVocabulary updateTaxonomyVocabulary(TaxonomyVocabulary taxonomyVocabulary) throws DrupalException {
        taxonomyVocabulary = (TaxonomyVocabulary)this.update(DrupalCollection.TaxonomyVocabulary, taxonomyVocabulary.getVid().toString(), taxonomyVocabulary);
        return taxonomyVocabulary;
    }

    @Override
    public String connectionId() {
        if (this.sessionId != null) {
            return this.sessionId.toString();
        }
        return this.server;
    }

    @Override
    public int countAllComments(int nodeId) throws DrupalException {
        WebResource.Builder builder = (WebResource.Builder)this.getWebResource().path(DrupalCollection.Comment.getEndpoint()).path(COUNT_ALL).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).cookie((Cookie)this.sessionId);
        CountRequest cr = new CountRequest();
        cr.setNodeId(nodeId);
        builder = (WebResource.Builder)builder.entity((Object)GsonFactory.getGson().toJson((Object)cr), MediaType.APPLICATION_JSON_TYPE);
        ClientResponse response = (ClientResponse)builder.method("POST", ClientResponse.class);
        ClientResponse.Status status = response.getClientResponseStatus();
        if (status == ClientResponse.Status.OK) {
            String json = (String)response.getEntity(String.class);
            int[] commentCount = (int[])GsonFactory.getGson().fromJson(json, int[].class);
            if (commentCount.length > 0) {
                return commentCount[0];
            }
        } else {
            if (status == ClientResponse.Status.UNAUTHORIZED) {
                throw new DrupalException("Drupal returned " + status.getStatusCode());
            }
            throw new DrupalException(String.format("API returned status code %d, 200 was expected. Reason:%s", status.getStatusCode(), status.getReasonPhrase()));
        }
        return 0;
    }

    @Override
    public int countNewComments(int nodeId, int since) throws DrupalException {
        WebResource.Builder builder = (WebResource.Builder)this.getWebResource().path(DrupalCollection.Comment.getEndpoint()).path(COUNT_NEW).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).cookie((Cookie)this.sessionId);
        CountRequest cr = new CountRequest();
        cr.setNodeId(nodeId);
        cr.setSince(since);
        builder = (WebResource.Builder)builder.entity((Object)GsonFactory.getGson().toJson((Object)cr), MediaType.APPLICATION_JSON_TYPE);
        ClientResponse response = (ClientResponse)builder.method("POST", ClientResponse.class);
        ClientResponse.Status status = response.getClientResponseStatus();
        if (status == ClientResponse.Status.OK) {
            String json = (String)response.getEntity(String.class);
            int[] commentCount = (int[])GsonFactory.getGson().fromJson(json, int[].class);
            if (commentCount.length > 0) {
                return commentCount[0];
            }
        } else {
            if (status == ClientResponse.Status.UNAUTHORIZED) {
                throw new DrupalException("Drupal returned " + status.getStatusCode());
            }
            throw new DrupalException(String.format("API returned status code %d, 200 was expected. Reason:%s", status.getStatusCode(), status.getReasonPhrase()));
        }
        return 0;
    }

    @Override
    public User registerUser(User user) throws DrupalException {
        User createdUser = (User)this.executeRequest("POST", this.getWebResource().path(DrupalCollection.User.getEndpoint()).path(REGISTER), DrupalCollection.User, user);
        user.setUid(createdUser.getUid());
        return user;
    }

    @Override
    public List<Node> indexNodes(List<String> fields, int startPage, int pagesize) throws DrupalException {
        List<Node> list = null;
        Type listType = new TypeToken<List<Node>>(){}.getType();
        list = this.index(DrupalCollection.Node, fields, startPage, pagesize, listType);
        return list;
    }

    @Override
    public List<Comment> indexComments(List<String> fields, int startPage, int pagesize) throws DrupalException {
        List<Comment> list = null;
        Type listType = new TypeToken<List<Comment>>(){}.getType();
        list = this.index(DrupalCollection.Comment, fields, startPage, pagesize, listType);
        return list;
    }

    @Override
    public List<User> indexUsers(List<String> fields, int startPage, int pagesize) throws DrupalException {
        List<User> list = null;
        Type listType = new TypeToken<List<User>>(){}.getType();
        list = this.index(DrupalCollection.User, fields, startPage, pagesize, listType);
        return list;
    }

    @Override
    public List<TaxonomyTerm> indexTaxonomyTerms(List<String> fields, int startPage, int pagesize) throws DrupalException {
        List<TaxonomyTerm> list = null;
        Type listType = new TypeToken<List<TaxonomyTerm>>(){}.getType();
        list = this.index(DrupalCollection.TaxonomyTerm, fields, startPage, pagesize, listType);
        return list;
    }

    @Override
    public List<TaxonomyVocabulary> indexTaxonomyVocabulary(List<String> fields, int startPage, int pagesize) throws DrupalException {
        List<TaxonomyVocabulary> list = null;
        Type listType = new TypeToken<List<TaxonomyVocabulary>>(){}.getType();
        list = this.index(DrupalCollection.TaxonomyVocabulary, fields, startPage, pagesize, listType);
        return list;
    }

    @Override
    public List<File> indexFiles(List<String> fields, int startPage, int pagesize) throws DrupalException {
        List<File> list = null;
        Type listType = new TypeToken<List<File>>(){}.getType();
        list = this.index(DrupalCollection.File, fields, startPage, pagesize, listType);
        return list;
    }

    private <T> List<T> index(DrupalCollection collection, List<String> fields, int startPage, int pagesize, Type listType) throws DrupalException {
        WebResource wr = this.getWebResource().path(collection.getEndpoint());
        if (startPage >= 0) {
            wr = wr.queryParam("page", String.valueOf(startPage));
        }
        if (pagesize > 0) {
            wr = wr.queryParam("pagesize", String.valueOf(pagesize));
        }
        if (fields != null && fields.size() > 0) {
            String requiredFields = StringUtils.join((Object[])fields.toArray(), (String)",");
            wr = wr.queryParam("fields", requiredFields);
        }
        return this.executeListRequest("GET", wr, listType, null);
    }

    @Override
    public List<Node> getNodesWithTerm(int termId) throws DrupalException {
        List<Node> list = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tid", String.valueOf(termId));
        WebResource wr = this.getWebResource().path(DrupalCollection.TaxonomyTerm.getEndpoint()).path(ACTION_SELECTNODES);
        Type listType = new TypeToken<List<Node>>(){}.getType();
        list = this.executeListRequest("POST", wr, listType, params);
        return list;
    }

    @Override
    public List<TaxonomyTerm> getTaxonomyVocabularyTree(int vocabularyId, int parent, int maxdepth) throws DrupalException {
        List<TaxonomyTerm> list = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vid", String.valueOf(vocabularyId));
        if (parent >= 0) {
            params.put("parent", String.valueOf(parent));
        }
        if (maxdepth > 0) {
            params.put("maxdepth", String.valueOf(maxdepth));
        }
        WebResource wr = this.getWebResource().path(DrupalCollection.TaxonomyVocabulary.getEndpoint()).path(ACTION_GETTREE);
        Type listType = new TypeToken<List<TaxonomyTerm>>(){}.getType();
        list = this.executeListRequest("POST", wr, listType, params);
        return list;
    }

    @Override
    public List<Comment> getCommentsForNode(int nodeId) throws DrupalException {
        ArrayList<Comment> list = null;
        WebResource wr = this.getWebResource().path(DrupalCollection.Node.getEndpoint()).path(String.valueOf(nodeId)).path(RELATIONSHIP_COMMENTS);
        Type listType = new TypeToken<Map<String, Comment>>(){}.getType();
        WebResource.Builder builder = (WebResource.Builder)wr.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).cookie((Cookie)this.sessionId);
        ClientResponse response = (ClientResponse)builder.method("GET", ClientResponse.class);
        ClientResponse.Status status = response.getClientResponseStatus();
        if (status == ClientResponse.Status.OK) {
            String json = (String)response.getEntity(String.class);
            Map apiResponse = (Map)GsonFactory.getGson().fromJson(json, listType);
            list = new ArrayList<Comment>(apiResponse.values());
            return list;
        }
        if (status == ClientResponse.Status.UNAUTHORIZED) {
            throw new DrupalException("Drupal returned " + status.getStatusCode());
        }
        throw new DrupalException(String.format("API returned status code %d, 200 was expected", status.getStatusCode()));
    }

    @Override
    public List<File> getFilesForNode(int nodeId) throws DrupalException {
        List<File> list = null;
        WebResource wr = this.getWebResource().path(DrupalCollection.Node.getEndpoint()).path(String.valueOf(nodeId)).path(RELATIONSHIP_FILES);
        Type listType = new TypeToken<List<File>>(){}.getType();
        list = this.executeListRequest("GET", wr, listType, null);
        return list;
    }
}

