/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.drupal;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mule.modules.drupal.DrupalCollection;
import org.mule.modules.drupal.GsonFactory;
import org.mule.modules.drupal.model.CustomField;
import org.mule.modules.drupal.model.DrupalEntity;

public class DrupalEntityDeserealizer
implements JsonDeserializer<DrupalEntity> {
    public DrupalEntity deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = GsonFactory.getGson();
        DrupalEntity entity = new DrupalEntity();
        JsonObject jsonObject = json.getAsJsonObject();
        Set members = jsonObject.entrySet();
        HashMap<String, CustomField> customFields = new HashMap<String, CustomField>();
        for (Map.Entry entry : members) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (!value.isJsonObject() || !this.isCustomField(value) || DrupalCollection.IsKnowCustomField(key)) continue;
            customFields.put(key, (CustomField)gson.fromJson(value, CustomField.class));
        }
        entity.setCustomFields(customFields);
        return entity;
    }

    private boolean isCustomField(JsonElement element) {
        JsonObject content;
        JsonElement undField;
        boolean isCustomField = false;
        if (element.isJsonObject() && (undField = (content = element.getAsJsonObject()).get("und")) != null) {
            isCustomField = undField.isJsonArray();
        }
        return isCustomField;
    }
}

