/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.drupal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.ConnectionException;
import org.mule.modules.drupal.DrupalCollection;
import org.mule.modules.drupal.client.DrupalClient;
import org.mule.modules.drupal.client.DrupalClientFactory;
import org.mule.modules.drupal.client.DrupalException;
import org.mule.modules.drupal.model.Comment;
import org.mule.modules.drupal.model.CustomField;
import org.mule.modules.drupal.model.File;
import org.mule.modules.drupal.model.Node;
import org.mule.modules.drupal.model.TaxonomyTerm;
import org.mule.modules.drupal.model.TaxonomyVocabulary;
import org.mule.modules.drupal.model.User;

public class DrupalConnector {
    protected DrupalClient client;
    private String server;
    private String apiUrl;
    private int port;
    private String userEndpoint;
    private String nodeEndpoint;
    private String commentEndpoint;
    private String fileEndpoint;
    private String taxonomyTermEndpoint;
    private String taxonomyVocabularyEndpoint;

    public void connect(String username, String password) throws ConnectionException {
        DrupalCollection.User.setEndpointName(this.userEndpoint);
        DrupalCollection.Node.setEndpointName(this.nodeEndpoint);
        DrupalCollection.Comment.setEndpointName(this.commentEndpoint);
        DrupalCollection.File.setEndpointName(this.fileEndpoint);
        DrupalCollection.TaxonomyTerm.setEndpointName(this.taxonomyTermEndpoint);
        DrupalCollection.TaxonomyVocabulary.setEndpointName(this.taxonomyVocabularyEndpoint);
        this.client = DrupalClientFactory.getClient(this.server, this.port, this.apiUrl);
        this.client.login(username, password);
    }

    public void disconnect() {
        try {
            this.client.logout();
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        this.client = null;
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    public String connectionId() {
        return this.client.connectionId();
    }

    public Node readNode(String nodeId) throws DrupalException {
        return this.client.readNode(nodeId);
    }

    public Comment readComment(String commentId) throws DrupalException {
        return this.client.readComment(commentId);
    }

    public User readUser(String userId) throws DrupalException {
        return this.client.readUser(userId);
    }

    public TaxonomyTerm readTaxonomyTerm(String taxonomyTermId) throws DrupalException {
        return this.client.readTaxonomyTerm(taxonomyTermId);
    }

    public File readFile(String fileId) throws DrupalException {
        return this.client.readFile(fileId);
    }

    public TaxonomyVocabulary readTaxonomyVocabulary(String vocabularyId) throws DrupalException {
        return this.client.readTaxonomyVocabulary(vocabularyId);
    }

    public Node createNode(Node node) throws DrupalException {
        return this.client.createNode(node);
    }

    public Comment createComment(Comment comment) throws DrupalException {
        return this.client.createComment(comment);
    }

    public User createUser(User user) throws DrupalException {
        return this.client.createUser(user);
    }

    public TaxonomyTerm createTaxonomyTerm(TaxonomyTerm taxonomyTerm) throws DrupalException {
        return this.client.createTaxonomyTerm(taxonomyTerm);
    }

    public File createFile(File file) throws DrupalException {
        return this.client.createFile(file);
    }

    public TaxonomyVocabulary createTaxonomyVocabulary(TaxonomyVocabulary taxonomyVocabulary) throws DrupalException {
        return this.client.createTaxonomyVocabulary(taxonomyVocabulary);
    }

    public User registerUser(User user) throws DrupalException {
        return this.client.registerUser(user);
    }

    public Node updateNode(Node node) throws DrupalException {
        return this.client.updateNode(node);
    }

    public Comment updateComment(Comment comment) throws DrupalException {
        return this.client.updateComment(comment);
    }

    public User updateUser(User user) throws DrupalException {
        return this.client.updateUser(user);
    }

    public TaxonomyTerm updateTaxonomyTerm(TaxonomyTerm taxonomyTerm) throws DrupalException {
        return this.client.updateTaxonomyTerm(taxonomyTerm);
    }

    public File updateFile(File file) throws DrupalException {
        return this.client.updateFile(file);
    }

    public TaxonomyVocabulary updateTaxonomyVocabulary(TaxonomyVocabulary taxonomyVocabulary) throws DrupalException {
        return this.client.updateTaxonomyVocabulary(taxonomyVocabulary);
    }

    public void deleteNode(int nodeId) throws DrupalException {
        this.client.deleteNode(nodeId);
    }

    public void deleteComment(int commentId) throws DrupalException {
        this.client.deleteComment(commentId);
    }

    public void deleteFile(int fileId) throws DrupalException {
        this.client.deleteFile(fileId);
    }

    public void deleteTaxonomyVocabulary(int taxonomyVocId) throws DrupalException {
        this.client.deleteTaxonomyVocabulary(taxonomyVocId);
    }

    public void deleteTaxonomyTerm(int taxonomyTermId) throws DrupalException {
        this.client.deleteTaxonomyTerm(taxonomyTermId);
    }

    public void deleteUser(int userId) throws DrupalException {
        this.client.deleteUser(userId);
    }

    public int countAllComments(int nodeId) throws DrupalException {
        return this.client.countAllComments(nodeId);
    }

    public int countNewComments(int nodeId, int since) throws DrupalException {
        return this.client.countNewComments(nodeId, since);
    }

    public List<Node> indexNodes(List<String> fields, int startPage, int pagesize) throws DrupalException {
        return this.client.indexNodes(fields, startPage, pagesize);
    }

    public List<Comment> indexComments(List<String> fields, int startPage, int pagesize) throws DrupalException {
        return this.client.indexComments(fields, startPage, pagesize);
    }

    public List<User> indexUsers(List<String> fields, int startPage, int pagesize) throws DrupalException {
        return this.client.indexUsers(fields, startPage, pagesize);
    }

    public List<TaxonomyTerm> indexTaxonomyTerms(List<String> fields, int startPage, int pagesize) throws DrupalException {
        return this.client.indexTaxonomyTerms(fields, startPage, pagesize);
    }

    public List<TaxonomyVocabulary> indexTaxonomyVocabulary(List<String> fields, int startPage, int pagesize) throws DrupalException {
        return this.client.indexTaxonomyVocabulary(fields, startPage, pagesize);
    }

    public List<File> indexFiles(List<String> fields, int startPage, int pagesize) throws DrupalException {
        return this.client.indexFiles(fields, startPage, pagesize);
    }

    public List<Node> getNodesWithTerm(int taxonomyTermId) throws DrupalException {
        return this.client.getNodesWithTerm(taxonomyTermId);
    }

    public List<TaxonomyTerm> getTaxonomyVocabularyTree(int vocabularyId, int parent, int maxdepth) throws DrupalException {
        return this.client.getTaxonomyVocabularyTree(vocabularyId, parent, maxdepth);
    }

    public List<Comment> getCommentsForNode(int nodeId) throws DrupalException {
        return this.client.getCommentsForNode(nodeId);
    }

    public List<File> getFilesForNode(int nodeId) throws DrupalException {
        return this.client.getFilesForNode(nodeId);
    }

    public void updateCustomFieldForNode(int nodeId, String fieldName, Map<String, String> customProperties) throws DrupalException {
        Node nod = new Node();
        nod.setNid(nodeId);
        CustomField field = new CustomField();
        HashMap<String, CustomField> map = new HashMap<String, CustomField>();
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(customProperties);
        field.setUnd(list);
        map.put(fieldName, field);
        nod.setCustomFields(map);
        this.client.updateNode(nod);
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getNodeEndpoint() {
        return this.nodeEndpoint;
    }

    public void setNodeEndpoint(String nodeEndpoint) {
        this.nodeEndpoint = nodeEndpoint;
    }

    public String getCommentEndpoint() {
        return this.commentEndpoint;
    }

    public void setCommentEndpoint(String commentEndpoint) {
        this.commentEndpoint = commentEndpoint;
    }

    public String getFileEndpoint() {
        return this.fileEndpoint;
    }

    public void setFileEndpoint(String fileEndpoint) {
        this.fileEndpoint = fileEndpoint;
    }

    public String getTaxonomyTermEndpoint() {
        return this.taxonomyTermEndpoint;
    }

    public void setTaxonomyTermEndpoint(String taxonomyTermEndpoint) {
        this.taxonomyTermEndpoint = taxonomyTermEndpoint;
    }

    public String getTaxonomyVocabularyEndpoint() {
        return this.taxonomyVocabularyEndpoint;
    }

    public void setTaxonomyVocabularyEndpoint(String taxonomyVocabularyEndpoint) {
        this.taxonomyVocabularyEndpoint = taxonomyVocabularyEndpoint;
    }

    public String getUserEndpoint() {
        return this.userEndpoint;
    }

    public void setUserEndpoint(String userEndpoint) {
        this.userEndpoint = userEndpoint;
    }
}

