/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.drupal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.modules.drupal.model.Comment;
import org.mule.modules.drupal.model.File;
import org.mule.modules.drupal.model.Node;
import org.mule.modules.drupal.model.TaxonomyTerm;
import org.mule.modules.drupal.model.TaxonomyVocabulary;
import org.mule.modules.drupal.model.User;

public enum DrupalCollection {
    Node("node", "node", Node.class),
    Comment("comment", "comment", Comment.class),
    User("user", "user", User.class),
    File("file", "file", File.class),
    TaxonomyTerm("taxonomy_term", "taxonomy_term", TaxonomyTerm.class),
    TaxonomyVocabulary("taxonomy_vocabulary", "taxonomy_vocabulary", TaxonomyVocabulary.class);

    private String entityName;
    private String endpoint;
    private Class<?> type;
    private static final Map<String, DrupalCollection> name2Instance;
    private static Set<String> knowCustomFields;

    public static DrupalCollection getByCollectionName(String collectionName) {
        return name2Instance.get(collectionName);
    }

    public static boolean IsKnowCustomField(String customField) {
        return knowCustomFields.contains(customField);
    }

    private DrupalCollection(String endpoint, String entityName, Class<?> collectionClass) {
        this.entityName = entityName;
        this.endpoint = endpoint;
        this.type = collectionClass;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpointName(String endpoint) {
        this.endpoint = endpoint;
    }

    public Class<?> getType() {
        return this.type;
    }

    static {
        name2Instance = new HashMap<String, DrupalCollection>();
        for (DrupalCollection collection : DrupalCollection.values()) {
            name2Instance.put(collection.getEntityName(), collection);
        }
        knowCustomFields = new HashSet<String>();
        knowCustomFields.add("body");
        knowCustomFields.add("comment_body");
    }
}

