/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.drupal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import org.mule.modules.drupal.GsonFactory;
import org.mule.modules.drupal.model.DrupalEntity;

public class CustomFieldsMapSerializer
implements JsonSerializer<DrupalEntity> {
    private static final String CUSTOM_FIELDS = "customFields";

    public JsonElement serialize(DrupalEntity src, Type typeOfSrc, JsonSerializationContext context) {
        Gson gson = GsonFactory.getGson();
        JsonObject jObj = (JsonObject)gson.toJsonTree((Object)src);
        if (this.isARequestHolder(jObj)) {
            Map.Entry entry = (Map.Entry)jObj.entrySet().iterator().next();
            if (entry.getValue() != null) {
                this.promoteCustomFieldsToParent(((JsonElement)entry.getValue()).getAsJsonObject());
            }
        } else {
            this.promoteCustomFieldsToParent(jObj);
        }
        return jObj;
    }

    private boolean isARequestHolder(JsonObject jObj) {
        return jObj.entrySet().size() == 1;
    }

    private void promoteCustomFieldsToParent(JsonObject drupalEntity) {
        if (drupalEntity != null) {
            JsonObject customFields = drupalEntity.getAsJsonObject(CUSTOM_FIELDS);
            if (customFields != null && customFields.isJsonObject()) {
                for (Map.Entry entry : customFields.entrySet()) {
                    drupalEntity.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
            drupalEntity.remove(CUSTOM_FIELDS);
        }
    }
}

