/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.drools;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.conf.AssertBehaviorOption;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.mule.api.config.ConfigurationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.bpm.MessageService;
import org.mule.module.bpm.Rules;
import org.mule.module.bpm.RulesEngine;
import org.mule.module.drools.DroolsSessionData;
import org.mule.module.drools.WorkingMemorySLF4JLogger;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Drools
implements RulesEngine {
    public static final String USE_EQUALITY_ASSERT_BEHAVIOR = "mule.drools.useEqualityAssert";
    private String name;
    private MessageService messageService;
    protected static final Logger logger = LoggerFactory.getLogger(Drools.class);

    public Object createSession(Rules rules) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{Thread.currentThread().getContextClassLoader()}));
        String rulesFile = rules.getResource();
        InputStream is = IOUtils.getResourceAsStream((String)rulesFile, this.getClass());
        if (is == null) {
            throw new IOException(CoreMessages.cannotLoadFromClasspath((String)rulesFile).getMessage());
        }
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)is), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new ConfigurationException(MessageFactory.createStaticMessage((String)("Errors while parsing ruleset defined in file " + rulesFile + " : " + kbuilder.getErrors().toString())));
        }
        KnowledgeBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{Thread.currentThread().getContextClassLoader()});
        if (this.useEqualityAssertBehavior()) {
            conf.setOption((KnowledgeBaseOption)AssertBehaviorOption.EQUALITY);
        }
        if (rules.getConfiguration() != null) {
            conf.setOption((KnowledgeBaseOption)rules.getConfiguration());
        } else if (rules.isCepMode()) {
            conf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)conf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        if (rules.isStateless()) {
            throw new ConfigurationException(MessageFactory.createStaticMessage((String)"Stateless sessions are not yet supported"));
        }
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        WorkingMemorySLF4JLogger droolsLogger = new WorkingMemorySLF4JLogger((KnowledgeRuntimeEventManager)session, logger);
        if (this.messageService == null) {
            throw new ConfigurationException(MessageFactory.createStaticMessage((String)"MessageService is not available"));
        }
        session.setGlobal("mule", (Object)this.messageService);
        session.fireAllRules();
        return new DroolsSessionData(session, droolsLogger);
    }

    public void disposeSession(Object sessionData) throws Exception {
        ((DroolsSessionData)sessionData).getSession().dispose();
        ((DroolsSessionData)sessionData).getLogger().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object assertFact(Rules rules, Object fact) throws Exception {
        StatefulKnowledgeSession session = ((DroolsSessionData)rules.getSessionData()).getSession();
        FactHandle handle = session.getFactHandle(fact);
        StatefulKnowledgeSession statefulKnowledgeSession = session;
        synchronized (statefulKnowledgeSession) {
            if (handle != null) {
                session.update(handle, fact);
                session.fireAllRules();
            } else {
                handle = session.insert(fact);
                session.fireAllRules();
            }
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retractFact(Rules rules, Object fact) throws Exception {
        StatefulKnowledgeSession session = ((DroolsSessionData)rules.getSessionData()).getSession();
        FactHandle handle = session.getFactHandle(fact);
        StatefulKnowledgeSession statefulKnowledgeSession = session;
        synchronized (statefulKnowledgeSession) {
            if (handle != null) {
                session.retract(handle);
                session.fireAllRules();
            } else {
                logger.warn("Unable to retract fact " + fact + " because it is not in the knowledge base");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object assertEvent(Rules rules, Object event, String entryPoint) throws Exception {
        WorkingMemoryEntryPoint wmEntryPoint;
        StatefulKnowledgeSession session = ((DroolsSessionData)rules.getSessionData()).getSession();
        if (entryPoint != null) {
            wmEntryPoint = session.getWorkingMemoryEntryPoint(entryPoint);
        } else {
            Collection entryPoints = session.getWorkingMemoryEntryPoints();
            if (entryPoints.size() > 1) {
                throw new ConfigurationException(MessageFactory.createStaticMessage((String)"Rules contain more than one entry point but none has been specified"));
            }
            wmEntryPoint = (WorkingMemoryEntryPoint)entryPoints.iterator().next();
        }
        FactHandle handle = session.getFactHandle(event);
        StatefulKnowledgeSession statefulKnowledgeSession = session;
        synchronized (statefulKnowledgeSession) {
            if (handle != null) {
                wmEntryPoint.update(handle, event);
            } else {
                handle = wmEntryPoint.insert(event);
            }
            session.fireAllRules();
        }
        return handle;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private boolean useEqualityAssertBehavior() {
        return Boolean.getBoolean(USE_EQUALITY_ASSERT_BEHAVIOR);
    }
}

