/**
 * Copyright (c) MuleSoft, Inc. All rights reserved. http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.md file.
 */
/**
 * This file was automatically generated by the Mule Development Kit
 */

package org.mule.modules.documentum.coreservices;

import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.mule.modules.documentum.HeaderHandler;
import org.mule.modules.documentum.Utils;

import com.emc.documentum.fs.datamodel.core.CacheStrategyType;
import com.emc.documentum.fs.datamodel.core.context.ServiceContext;
import com.emc.documentum.fs.datamodel.core.query.QueryExecution;
import com.emc.documentum.fs.datamodel.core.query.QueryResult;
import com.emc.documentum.fs.services.core.QueryService;
import com.emc.documentum.fs.services.core.QueryServicePort;
import com.emc.documentum.fs.services.core.SerializableException;

public class QueryClientImpl implements QueryClient {

    private QueryServicePort port;
    private ServiceContext serviceContext;

    public QueryClientImpl(String target, ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        setQueryPort(target);
    }

    public QueryResult query(String dqlStatement) throws SerializableException {
        return port.execute(Utils.createQuery(dqlStatement, serviceContext), createQueryExecution(CacheStrategyType.NO_CACHE_STRATEGY), null);
    }

    private QueryExecution createQueryExecution(CacheStrategyType cacheStrategyType) {
        QueryExecution queryEx = new QueryExecution();
        queryEx.setCacheStrategyType(cacheStrategyType);
        queryEx.setMaxResultCount(Integer.MAX_VALUE);
        return queryEx;
    }

    private void setQueryPort(String target) {
        QueryService queryService = new QueryService();
        queryService.setHandlerResolver(new HandlerResolver() {

            @SuppressWarnings("rawtypes")
            public List<Handler> getHandlerChain(PortInfo info) {
                List<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add(new HeaderHandler(serviceContext));
                return handlerList;
            }
        });
        port = queryService.getQueryServicePort();
        ((BindingProvider) port).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, target + "core/QueryService");
    }

}