package com.emc.documentum.fs.services.core.acl;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;

/**
 * This class was generated by Apache CXF 2.7.15
 * 2015-12-11T17:08:18.271-03:00
 * Generated source version: 2.7.15
 * 
 */
@WebService(targetNamespace = "http://acl.core.services.fs.documentum.emc.com/", name = "AccessControlServicePort")
@XmlSeeAlso({com.emc.documentum.fs.datamodel.core.ObjectFactory.class, com.emc.documentum.fs.datamodel.core.acl.ObjectFactory.class, com.emc.documentum.fs.rt.ObjectFactory.class, ObjectFactory.class})
public interface AccessControlServicePort {

    /**
     * Creates new ACL objects based on the Acl instances contained in an AclPackage passed to
     * the operation.<p>
     * 
     * @param aclPackage AclPackage containing a list of ACLs to be created
     * @return  AclPackage containing a list of created ACLs
     * @throws com.emc.documentum.fs.services.core.CoreServiceException
     */
    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "create", targetNamespace = "http://acl.core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.acl.Create")
    @WebMethod
    @ResponseWrapper(localName = "createResponse", targetNamespace = "http://acl.core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.acl.CreateResponse")
    public com.emc.documentum.fs.datamodel.core.acl.AclPackage create(
        @WebParam(name = "aclPackage", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.acl.AclPackage aclPackage
    ) throws ServiceException, CoreServiceException_Exception;

    /**
     * Deletes ACL objects based on a list of Acl identities passed to the operation.<p>
     * 
     * @param aclIdentities the identities of the ACLs to delete
     * @throws com.emc.documentum.fs.services.core.CoreServiceException
     */
    @RequestWrapper(localName = "delete", targetNamespace = "http://acl.core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.acl.Delete")
    @WebMethod
    @ResponseWrapper(localName = "deleteResponse", targetNamespace = "http://acl.core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.acl.DeleteResponse")
    public void delete(
        @WebParam(name = "aclIdentities", targetNamespace = "")
        java.util.List<com.emc.documentum.fs.datamodel.core.acl.AclIdentity> aclIdentities
    ) throws ServiceException, CoreServiceException_Exception;

    /**
     * Updates a List of ACL objects based on the Acl instances contained in an AclPackage passed to
     * the operation.<p>
     * The update operation does not merge the data in an Acl instance into an existing ACL repository object.
     *  It instead replaces all of the attribute values in an ACL object based on the data in the Acl instance passed to the operation.
     *       
     * @param aclPackage AclPackage containing a List of ACLs to be created
     * @return AclPackage containing a List of updated ACLs
     * @throws com.emc.documentum.fs.services.core.CoreServiceException
     */
    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "update", targetNamespace = "http://acl.core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.acl.Update")
    @WebMethod
    @ResponseWrapper(localName = "updateResponse", targetNamespace = "http://acl.core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.acl.UpdateResponse")
    public com.emc.documentum.fs.datamodel.core.acl.AclPackage update(
        @WebParam(name = "aclPackage", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.acl.AclPackage aclPackage
    ) throws ServiceException, CoreServiceException_Exception;

    /**
     * Gets an AclPackage containing ACL objects based on the Acl identities passed to the operation.<p>
     * 
     * @param aclIdentities List containing the identities of the ACLs to get
     * @return AclPackage containing a List of ACL objects
     * @throws com.emc.documentum.fs.services.core.CoreServiceException
     */
    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "get", targetNamespace = "http://acl.core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.acl.Get")
    @WebMethod
    @ResponseWrapper(localName = "getResponse", targetNamespace = "http://acl.core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.acl.GetResponse")
    public com.emc.documentum.fs.datamodel.core.acl.AclPackage get(
        @WebParam(name = "aclIdentities", targetNamespace = "")
        java.util.List<com.emc.documentum.fs.datamodel.core.acl.AclIdentity> aclIdentities
    ) throws ServiceException, CoreServiceException_Exception;
}
