package com.emc.documentum.fs.services.core;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;

/**
 * This class was generated by Apache CXF 2.7.15
 * 2015-12-11T17:08:19.418-03:00
 * Generated source version: 2.7.15
 * 
 */
@WebService(targetNamespace = "http://core.services.fs.documentum.emc.com/", name = "QueryServicePort")
@XmlSeeAlso({com.emc.documentum.fs.datamodel.core.profiles.ObjectFactory.class, com.emc.documentum.fs.datamodel.core.ObjectFactory.class, com.emc.documentum.fs.datamodel.core.content.ObjectFactory.class, com.emc.documentum.fs.rt.ObjectFactory.class, com.emc.documentum.fs.datamodel.core.properties.ObjectFactory.class, com.emc.documentum.fs.datamodel.core.query.ObjectFactory.class, ObjectFactory.class, com.emc.documentum.fs.datamodel.core.schema.ObjectFactory.class})
public interface QueryServicePort {

    /**
     * The execute operation runs a query against data in a repository and returns the results to the client as a
     *  QueryResult containing a DataPackage.<p>
     * 
     *  Executes a DQL query. <p>
     *  Notes: <p>
     *  1) Only PassthroughQuery is supported for query parameter. <p>
     *  2) Only one repository can be specified in the query otherwise an CoreServiceException will be thrown.
     *  3) When cache strategy is used, query id can be set in execution for sequential processing of cached query results.
     *   Considering cache expiration, the query string should also be set in query, which will be used to update the cache.
     *   Make sure the original query string is used.
     * 
     *  @param query - query object
     *  @param execution various parameters for query execution (cache strategy, max result, starting index, query id,...)
     *  @param options service options (override profiles were passed using ServiceContext)
     *  @return QueryResult result of query execution. <p>
     * <li> If succeed QueryResult.status.repositoryStatusInfos[0].status == Status.SUCCESS
     * <li> If failed and if Continue-on-exception-payload-policy (see {@link com.emc.documentum.fs.rt.context.IServiceContext#PAYLOAD_PROCESSING_POLICY PAYLOAD_PROCESSING_POLICY}) is used then QueryResult.status.repositoryStatusInfos[0].status == Status.FAILURE
     * <li> If failed and if Continue-on-exception-payload-policy is not used then an exception will be thrown 
     * <li> If query have more elements than were returned QueryResult.status.hasMoreResults is set to true otherwise to
     *   false
     *  @throws CoreServiceException
     *  @throws QueryValidationException
     *  @throws CacheException
     *  @see com.emc.documentum.fs.datamodel.core.query.PassthroughQuery
     *  @see com.emc.documentum.fs.datamodel.core.query.QueryExecution
     *  @see com.emc.documentum.fs.datamodel.core.OperationOptions
     *  @see com.emc.documentum.fs.datamodel.core.query.QueryResult
     */
    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "execute", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.Execute")
    @WebMethod
    @ResponseWrapper(localName = "executeResponse", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.ExecuteResponse")
    public com.emc.documentum.fs.datamodel.core.query.QueryResult execute(
        @WebParam(name = "query", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.query.Query query,
        @WebParam(name = "execution", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.query.QueryExecution execution,
        @WebParam(name = "options", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.OperationOptions options
    ) throws SerializableException;
}
