package com.emc.documentum.fs.services.core;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;

/**
 * This class was generated by Apache CXF 2.7.15
 * 2015-12-11T17:08:21.019-03:00
 * Generated source version: 2.7.15
 * 
 */
@WebService(targetNamespace = "http://core.services.fs.documentum.emc.com/", name = "ObjectServicePort")
@XmlSeeAlso({com.emc.documentum.fs.datamodel.core.profiles.ObjectFactory.class, com.emc.documentum.fs.datamodel.core.ObjectFactory.class, com.emc.documentum.fs.datamodel.core.content.ObjectFactory.class, com.emc.documentum.fs.rt.ObjectFactory.class, com.emc.documentum.fs.datamodel.core.properties.ObjectFactory.class, com.emc.documentum.fs.datamodel.core.query.ObjectFactory.class, ObjectFactory.class})
public interface ObjectServicePort {

    /**
     * The createPath operation creates a folder structure (from the cabinet down) in a repository. Notice that only
     * "object_name" property will be set for each object.<p>
     * If any of the folders specified in the path exist, no exception is thrown. This allows you to use the operation
     * to create the complete path, or to add new folders to an existing path.
     * 
     * @param objectPath      Contains a String in the form "/cabinetName/folderName..." that describes the complete
     *                        path to create.
     * @param repositoryName  the repository name where the objects will be created.  
     * @return Returns the ObjectIdentity of the final object in the path. For example, if the path is
     *         "/cabinetName/childFolder1/childFolder2", the operation will return the ObjectIdentity of childFolder2.
     * @throws CoreServiceException
     */
    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "createPath", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.CreatePath")
    @WebMethod
    @ResponseWrapper(localName = "createPathResponse", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.CreatePathResponse")
    public com.emc.documentum.fs.datamodel.core.ObjectIdentity createPath(
        @WebParam(name = "objectPath", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.ObjectPath objectPath,
        @WebParam(name = "repositoryName", targetNamespace = "")
        java.lang.String repositoryName
    ) throws SerializableException;

    /**
     * The validate operation validates a set of DataObject instances against repository data dictionary rules, testing
     * whether the DataObject instances represent valid repository objects, and whether the DataObject properties
     * represent valid repository properties.
     * 
     * @param dataPackage A collection of DataObject instances to be validated by the operation.
     * @return  a ValidationInfoSet, which contains a list of ValidationInfo objects. Each ValidationInfo contains a
     *          DataObject and a list of any ValidationIssue instances that were raised by the operation. A
     *          ValidationIssue can be of enum type ERROR or WARNING.
     * @throws com.emc.documentum.fs.services.core.CoreServiceException
     */
    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "validate", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.Validate")
    @WebMethod
    @ResponseWrapper(localName = "validateResponse", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.ValidateResponse")
    public com.emc.documentum.fs.datamodel.core.ValidationInfoSet validate(
        @WebParam(name = "dataPackage", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.DataPackage dataPackage
    ) throws SerializableException;

    /**
     * The move operation moves a set of repository objects from one location into another, and provides the optional
     * capability of updating the repository objects as they are moved. The move operation will only move the CURRENT
     * version of an object. If passed an ObjectIdentity that identifies a non-CURRENT object, the operation will throw
     * an exception (unless non-CURRENT objects are specifically permitted by a MoveProfile).<p>
     * 
     * <p>Note: Move from one repository into another repository is not permitted.
     *          DataPackage can contain operation specific properties.
     * 
     * @param fromObjects    A collection of ObjectIdentity instances that identify the repository objects to be moved.
     * @param sourceLocation Contains an ObjectIdentity that identifies the location (a cabinet or folder) from which
     *                       the repository objects are to be moved.
     * @param targetLocation Contains an ObjectIdentity that identifies the location (a cabinet or folder) into which
     *                       the repository objects are to be moved.
     * @param modifyObjects  Optionally contains a set of DataObject instances that contain modifications (such as
     *                       changes to property values, content, or relationships) to all or some of the repository
     *                       objects being moved. The ObjectIdentity of each DataObject must uniquely identify one of
     *                       the moved objects. The modifications supplied in the DataObject are applied during the move
     *                       operation.
     * @param options     An object containing profiles and properties that specify operation behaviors. If this object
     *                    is null, default operation behaviors will take effect.
     *                    It can contain MoveProfile that will modify the behaviour of the operation.
     *                    OperationOptions can also contain PropertyProfile, ContentProfile, PermissionProfile,
     *                    RelationshipProfile that will be used to populate the returned DataPackage. Also it can
     *                    contain ContentTransferProfile to specify the specifics of content transfer.
     * @return a DataPackage containing one DataObject for each repository object created by the move operation. By
     *         default, each DataObject contains only the ObjectIdentity of the created object and no other data. The
     *         client can modify this behavior by using Profile objects if it requires more data about the moved objects.
     * @throws com.emc.documentum.fs.services.core.CoreServiceException
     */
    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "move", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.Move")
    @WebMethod
    @ResponseWrapper(localName = "moveResponse", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.MoveResponse")
    public com.emc.documentum.fs.datamodel.core.DataPackage move(
        @WebParam(name = "fromObjects", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.ObjectIdentitySet fromObjects,
        @WebParam(name = "sourceLocation", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.ObjectLocation sourceLocation,
        @WebParam(name = "targetLocation", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.ObjectLocation targetLocation,
        @WebParam(name = "modifyObjects", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.DataPackage modifyObjects,
        @WebParam(name = "options", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.OperationOptions options
    ) throws SerializableException;

    /**
     * Operation deletes a set of objects from the repository. By default, for each object that it deletes, it deletes
     * all versions. The specific behaviors of the delete operation are controlled by a DeleteProfile, which should be
     * passed to the operation as part of OperationOptions.<p>
     * 
     * <p>Note: DataPackage can contain operation specific properties
     * 
     * @param objectsToDelete A collection of ObjectIdentity instances that uniquely identify repository objects to be
     *                        deleted.
     * @param options     An object containing profiles and properties that specify operation behaviors. If this object
     *                    is null, default operation behaviors will take effect.
     *                    It can contain DeleteProfile that will modify the behaviour of the operation.
     *                    OperationOptions can also contain PropertyProfile, ContentProfile, PermissionProfile,
     *                    RelationshipProfile that will be used to populate the returned DataPackage. Also it can
     *                    contain ContentTransferProfile to specify the specifics of content transfer.
     * @throws com.emc.documentum.fs.services.core.CoreServiceException
     */
    @RequestWrapper(localName = "delete", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.Delete")
    @WebMethod
    @ResponseWrapper(localName = "deleteResponse", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.DeleteResponse")
    public void delete(
        @WebParam(name = "objectsToDelete", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.ObjectIdentitySet objectsToDelete,
        @WebParam(name = "options", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.OperationOptions options
    ) throws SerializableException;

    /**
     * Creates a set of new repository objects based on the DataObject instances contained in a DataPackage passed to
     * the operation. Because each DataObject represents a new repository object, its ObjectIdentity is populated with
     * only a repository name. Content Server assigns a unique object identifier when the object is created in the
     * repository.
     * 
     * To create an object in a specific location, or to create objects that have relationships to one another defined
     * in the repository, the client can define Relationship instances in a DataObject passed to the operation. The most
     * common example of this would be to create a Relationship between a newly created document and the folder in which
     * it is to be created.
     * All specified related objects are also created.  All content is automatically imported.
     * 
     * Note: DataPackage can contain operation specific properties.
     * 
     * @param dataPackage contains DataObjects that will be created
     * @param options     An object containing profiles and properties that specify operation behaviors. If this object
     *                    is null, default operation behaviors will take effect.
     *                    OperationOptions can contain PropertyProfile, ContentProfile, PermissionProfile,
     *                    RelationshipProfile that will be used to populate the returned DataPackage. Also it can
     *                    contain ContentTransferProfile to specify the specifics of content transfer.
     * @return target DataPackage with a list of objects created. By default, it will only return
     *         ObjectIdentity of the DataObjects with no ReferenceRelations.
     * @throws com.emc.documentum.fs.services.core.CoreServiceException
     */
    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "create", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.Create")
    @WebMethod
    @ResponseWrapper(localName = "createResponse", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.CreateResponse")
    public com.emc.documentum.fs.datamodel.core.DataPackage create(
        @WebParam(name = "dataPackage", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.DataPackage dataPackage,
        @WebParam(name = "options", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.OperationOptions options
    ) throws SerializableException;

    /**
     * The get operation retrieves a set of objects from the repository based on the contents of an ObjectIdentitySet.
     * The get operation always returns the version of the object specified by ObjectIdentity; if the ObjectIdentity
     * identifies a non-CURRENT version, the get operation returns the non-CURRENT version. The operation will also
     * return related objects if instructed to do so by RelationshipProfile settings.
     * 
     * @param forObjects  Contains a list of ObjectIdentity instances specifying the repository objects to be retrieved.
     * @param options     An object containing profiles and properties that specify operation behaviors. If this object
     *                    is null, default operation behaviors will take effect.
     *                    OperationOptions can contain PropertyProfile, ContentProfile, PermissionProfile,
     *                    RelationshipProfile that will be used to populate the returned DataPackage. Also it can
     *                    contain ContentTransferProfile to specify the specifics of content transfer.
     * @return fully populated DataObjects and their ReferenceRelations in case filter mode is not
     *         defined.
     * @throws com.emc.documentum.fs.services.core.CoreServiceException
     */
    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "get", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.Get")
    @WebMethod
    @ResponseWrapper(localName = "getResponse", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.GetResponse")
    public com.emc.documentum.fs.datamodel.core.DataPackage get(
        @WebParam(name = "forObjects", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.ObjectIdentitySet forObjects,
        @WebParam(name = "options", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.OperationOptions options
    ) throws SerializableException;

    /**
     * The copy operation copies a set of repository objects from one location to another, either within a single
     * repository, or from one repository to another. During the copy operation, the service can optionally make
     * modifications to the objects being copied.<p>
     * 
     * Note: For the service to copy an object from one repository to another, the ServiceContext must be set up to
     * provide the service with access to both repositories. This can be done by setting up a separate
     * RepositoryIdentity for each repository, or by use of a BasicIdentity, which provides default user credentials for
     * multiple repositories. For more information on RepositoryIdentity and BasicIdentity, see DFS Development Guide,
     * Identities, page 48.
     * 
     * <p>Note: DataPackage can contain operation specific properties.
     * 
     * @param fromObjects       is a set of identities pointing to objects that must be copied.
     * @param targetLocation    Contains an ObjectIdentity that identifies the location (a cabinet or folder) into which
     *                          the repository objects are to be copied. If objects do not require a "parent" location.
     *                          Location object can be used to specify target repository.
     * @param modifyObjects     optional package of data objects that need to be modified during a copy.  It is not
     *                          necessary to have as many "modify objects" as "from identities".  During processing of
     *                          each "from identity", data object with the same identity will be used to change the
     *                          attributes and relationships for the new object.
     * @param options     An object containing profiles and properties that specify operation behaviors. If this object
     *                    is null, default operation behaviors will take effect.
     *                    It can contain CopyProfile that will modify the behaviour of the operation.
     *                    OperationOptions can also contain PropertyProfile, ContentProfile, PermissionProfile,
     *                    RelationshipProfile that will be used to populate the returned DataPackage. Also it can
     *                    contain ContentTransferProfile to specify the specifics of content transfer.
     * @return target DataPackage with a list of objects created. By default, it will only return
     *         ObjectIdentity of the DataObjects with no ReferenceRelations. PropertyProfile and
     *         ContentProfile settings can be used to specify what data is populated.
     * @throws com.emc.documentum.fs.services.core.CoreServiceException
     */
    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "copy", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.Copy")
    @WebMethod
    @ResponseWrapper(localName = "copyResponse", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.CopyResponse")
    public com.emc.documentum.fs.datamodel.core.DataPackage copy(
        @WebParam(name = "fromObjects", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.ObjectIdentitySet fromObjects,
        @WebParam(name = "targetLocation", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.ObjectLocation targetLocation,
        @WebParam(name = "modifyObjects", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.DataPackage modifyObjects,
        @WebParam(name = "options", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.OperationOptions options
    ) throws SerializableException;

    /**
     * Returns an array of ContentUrl objects based on specified object identities.  Notice that more than one
     * ContentUrl can be returned per object identity.
     * 
     * @param forObjects   A collection of ObjectIdentity instances for which to obtain UrlContent objects.
     * @return List<ObjectContentSet>  each ObjectContentSet contains a list of UrlContent objects.
     * @throws com.emc.documentum.fs.services.core.CoreServiceException
     */
    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "getObjectContentUrls", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.GetObjectContentUrls")
    @WebMethod
    @ResponseWrapper(localName = "getObjectContentUrlsResponse", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.GetObjectContentUrlsResponse")
    public java.util.List<com.emc.documentum.fs.datamodel.core.ObjectContentSet> getObjectContentUrls(
        @WebParam(name = "forObjects", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.ObjectIdentitySet forObjects
    ) throws SerializableException;

    /**
     * The update operation updates a set of repository objects using data supplied in a set of DataObject instances
     * passed in a DataPackage. The update operation will only update the CURRENT version of an object. If passed an
     * ObjectIdentity that identifies a non-CURRENT object, the operation will throw an exception. The updated
     * repository object will be saved as the CURRENT version.
     * 
     * The ObjectIdentity of each DataObject passed to the update operation must uniquely identify an existing
     * repository object. The DataObject instances can contain updates to properties, content, and relationships, and
     * only needs to include data that requires update.
     * 
     * If a DataObject contains ReferenceRelationship instances, the corresponding relationships are created or updated
     * in the repository. The update operation can also remove existing relationships. It can therefore be used,
     * for example, to unlink an object from a folder and link it into another folder. If the DataObject contains
     * ObjectRelationship instances, then the related objects are either updated or created, depending on whether they
     * already exist in the repository. If the object does not exist, it is created; if it does exist, it is updated.
     * 
     * Updates all data object in the data package using the specified target repository. All specified related objects
     * are also updated.  All content is automatically saved as CURRENT as well.
     * 
     * Note: DataPackage can contain operation specific properties
     * 
     * @param dataPackage A collection of DataObject instances that contain modifications to repository objects. The
     *                    ObjectIdentity of each DataObject instance must uniquely identity the repository object to
     *                    update. The DataObject instance need only contain data that is to be modified on the
     *                    repository object; data that is to remain unchanged need not be supplied.
     * @param options     An object containing profiles and properties that specify operation behaviors. If this object
     *                    is null, default operation behaviors will take effect.
     *                    OperationOptions can contain PropertyProfile, ContentProfile, PermissionProfile,
     *                    RelationshipProfile that will be used to populate the returned DataPackage. Also it can
     *                    contain ContentTransferProfile to specify the specifics of content transfer.
     * @return DataPackage, which by default is populated with DataObject instances that contain only an ObjectIdentity.
     * @throws com.emc.documentum.fs.services.core.CoreServiceException
     */
    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "update", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.Update")
    @WebMethod
    @ResponseWrapper(localName = "updateResponse", targetNamespace = "http://core.services.fs.documentum.emc.com/", className = "com.emc.documentum.fs.services.core.UpdateResponse")
    public com.emc.documentum.fs.datamodel.core.DataPackage update(
        @WebParam(name = "dataPackage", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.DataPackage dataPackage,
        @WebParam(name = "options", targetNamespace = "")
        com.emc.documentum.fs.datamodel.core.OperationOptions options
    ) throws SerializableException;
}
