package com.emc.documentum.fs.services.core;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.Service;

/**
 * ObjectService Provides fundamental operations for creating, getting, updating, and deleting repository objects, as
 *  well as copy and move operations<p>
 * 
 *  The object service provides a set of basic operations on repository objects, in cases where the client does not need
 *  to explicitly use the version control system. Each operation within the object service uses default behaviors as
 *  relates to object versions that are appropriate for the specific operation. All of the object services can operate
 *  on multiple objects (contained in either a DataPackage or an ObjectIdentitySet), enabling clients to optimize service
 *  usage by minimizing the number of service interactions.
 * 
 *  @see com.emc.documentum.fs.datamodel.core.OperationOptions
 *  @see com.emc.documentum.fs.datamodel.core.profiles.Profile
 * 
 *  @since 6.0
 *
 * This class was generated by Apache CXF 2.7.15
 * 2015-12-11T17:08:21.032-03:00
 * Generated source version: 2.7.15
 * 
 */
@WebServiceClient(name = "ObjectService", 
                  wsdlLocation = "classpath:wsdl/6.6/ObjectService.wsdl",
                  targetNamespace = "http://core.services.fs.documentum.emc.com/") 
public class ObjectService extends Service {

    public final static URL WSDL_LOCATION;

    public final static QName SERVICE = new QName("http://core.services.fs.documentum.emc.com/", "ObjectService");
    public final static QName ObjectServicePort = new QName("http://core.services.fs.documentum.emc.com/", "ObjectServicePort");
    static {
        URL url = ObjectService.class.getClassLoader().getResource("wsdl/6.6/ObjectService.wsdl");
        if (url == null) {
            java.util.logging.Logger.getLogger(ObjectService.class.getName())
                .log(java.util.logging.Level.INFO, 
                     "Can not initialize the default wsdl from {0}", "classpath:wsdl/6.6/ObjectService.wsdl");
        }       
        WSDL_LOCATION = url;   
    }

    public ObjectService(URL wsdlLocation) {
        super(wsdlLocation, SERVICE);
    }

    public ObjectService(URL wsdlLocation, QName serviceName) {
        super(wsdlLocation, serviceName);
    }

    public ObjectService() {
        super(WSDL_LOCATION, SERVICE);
    }
    
    //This constructor requires JAX-WS API 2.2. You will need to endorse the 2.2
    //API jar or re-run wsdl2java with "-frontend jaxws21" to generate JAX-WS 2.1
    //compliant code instead.
    public ObjectService(WebServiceFeature ... features) {
        super(WSDL_LOCATION, SERVICE, features);
    }

    //This constructor requires JAX-WS API 2.2. You will need to endorse the 2.2
    //API jar or re-run wsdl2java with "-frontend jaxws21" to generate JAX-WS 2.1
    //compliant code instead.
    public ObjectService(URL wsdlLocation, WebServiceFeature ... features) {
        super(wsdlLocation, SERVICE, features);
    }

    //This constructor requires JAX-WS API 2.2. You will need to endorse the 2.2
    //API jar or re-run wsdl2java with "-frontend jaxws21" to generate JAX-WS 2.1
    //compliant code instead.
    public ObjectService(URL wsdlLocation, QName serviceName, WebServiceFeature ... features) {
        super(wsdlLocation, serviceName, features);
    }

    /**
     *
     * @return
     *     returns ObjectServicePort
     */
    @WebEndpoint(name = "ObjectServicePort")
    public ObjectServicePort getObjectServicePort() {
        return super.getPort(ObjectServicePort, ObjectServicePort.class);
    }

    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns ObjectServicePort
     */
    @WebEndpoint(name = "ObjectServicePort")
    public ObjectServicePort getObjectServicePort(WebServiceFeature... features) {
        return super.getPort(ObjectServicePort, ObjectServicePort.class, features);
    }

}
