/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.documentum.coreservices;

import com.emc.documentum.fs.datamodel.core.CheckoutInfo;
import com.emc.documentum.fs.datamodel.core.DataPackage;
import com.emc.documentum.fs.datamodel.core.ObjectIdentity;
import com.emc.documentum.fs.datamodel.core.ObjectIdentitySet;
import com.emc.documentum.fs.datamodel.core.OperationOptions;
import com.emc.documentum.fs.datamodel.core.VersionInfo;
import com.emc.documentum.fs.datamodel.core.VersionStrategy;
import com.emc.documentum.fs.datamodel.core.content.ContentTransferMode;
import com.emc.documentum.fs.datamodel.core.context.ServiceContext;
import com.emc.documentum.fs.datamodel.core.profiles.ContentProfile;
import com.emc.documentum.fs.datamodel.core.profiles.FormatFilter;
import com.emc.documentum.fs.datamodel.core.profiles.PageFilter;
import com.emc.documentum.fs.datamodel.core.profiles.PageModifierFilter;
import com.emc.documentum.fs.services.core.SerializableException;
import com.emc.documentum.fs.services.core.VersionControlService;
import com.emc.documentum.fs.services.core.VersionControlServicePort;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import org.mule.module.documentum.HeaderHandler;
import org.mule.module.documentum.Utils;
import org.mule.module.documentum.coreservices.VersionControlClient;

public class VersionControlClientImpl
implements VersionControlClient {
    private VersionControlServicePort port;
    private ServiceContext serviceContext;

    public VersionControlClientImpl(String target, ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this.setVersionControlPort(target);
    }

    @Override
    public CheckoutInfo getCheckoutInfo(ObjectIdentity objIdentity) throws SerializableException {
        ObjectIdentitySet objIdSet = Utils.createObjectIdentitySet(objIdentity);
        this.port.checkout(objIdSet, null);
        CheckoutInfo checkoutInfo = this.port.getCheckoutInfo(objIdSet).get(0);
        this.port.cancelCheckout(objIdSet);
        return checkoutInfo;
    }

    @Override
    public ObjectIdentity checkout(ObjectIdentity objIdentity) throws SerializableException {
        return this.port.checkout(Utils.createObjectIdentitySet(objIdentity), null).getDataObjects().get(0).getIdentity();
    }

    @Override
    public ObjectIdentity checkin(ObjectIdentity objIdentity, String newContentPath, VersionStrategy versionStrategy, List<String> labels, boolean isRetainLock, ContentTransferMode transferMode) throws SerializableException, IOException {
        OperationOptions operationOptions = Utils.createOperationOptions(this.createContentProfile(FormatFilter.ANY, PageFilter.ANY, -1, PageModifierFilter.ANY));
        DataPackage checkinPackage = this.port.checkout(Utils.createObjectIdentitySet(objIdentity), operationOptions);
        checkinPackage.getDataObjects().get(0).getContents().clear();
        Utils.addContent(checkinPackage.getDataObjects().get(0), transferMode, Utils.fileToByteArray(new File(newContentPath)));
        return this.port.checkin(checkinPackage, versionStrategy, isRetainLock, labels, operationOptions).getDataObjects().get(0).getIdentity();
    }

    @Override
    public ObjectIdentity cancelCheckout(ObjectIdentity objIdentity) throws SerializableException {
        this.port.cancelCheckout(Utils.createObjectIdentitySet(objIdentity));
        return objIdentity;
    }

    @Override
    public ObjectIdentity deleteVersion(ObjectIdentity objIdentity) throws SerializableException {
        this.port.deleteVersion(Utils.createObjectIdentitySet(objIdentity));
        return objIdentity;
    }

    @Override
    public ObjectIdentity deleteAllVersions(ObjectIdentity objIdentity) throws SerializableException {
        this.port.deleteAllVersions(Utils.createObjectIdentitySet(objIdentity));
        return objIdentity;
    }

    @Override
    public ObjectIdentity getCurrent(ObjectIdentity objIdentity) throws SerializableException {
        return this.port.getCurrent(Utils.createObjectIdentitySet(objIdentity), null).getDataObjects().get(0).getIdentity();
    }

    @Override
    public VersionInfo getVersionInfo(ObjectIdentity objIdentity) throws SerializableException {
        return this.port.getVersionInfo(Utils.createObjectIdentitySet(objIdentity)).get(0);
    }

    private ContentProfile createContentProfile(FormatFilter formatFilter, PageFilter pageFilter, int pageNumber, PageModifierFilter pageModifierFilter) {
        ContentProfile contentProfile = new ContentProfile();
        contentProfile.setFormatFilter(formatFilter);
        contentProfile.setPageFilter(pageFilter);
        contentProfile.setPageNumber(pageNumber);
        contentProfile.setPageModifierFilter(pageModifierFilter);
        return contentProfile;
    }

    private void setVersionControlPort(String target) {
        VersionControlService versionControlService = new VersionControlService();
        versionControlService.setHandlerResolver(new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo info) {
                ArrayList<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add((Handler)new HeaderHandler(VersionControlClientImpl.this.serviceContext));
                return handlerList;
            }
        });
        this.port = versionControlService.getVersionControlServicePort();
        ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", target + "core/VersionControlService");
    }
}

