/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.documentum.coreservices;

import com.emc.documentum.fs.datamodel.core.CacheStrategyType;
import com.emc.documentum.fs.datamodel.core.context.ServiceContext;
import com.emc.documentum.fs.datamodel.core.query.QueryExecution;
import com.emc.documentum.fs.datamodel.core.query.QueryResult;
import com.emc.documentum.fs.services.core.QueryService;
import com.emc.documentum.fs.services.core.QueryServicePort;
import com.emc.documentum.fs.services.core.SerializableException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import org.mule.module.documentum.HeaderHandler;
import org.mule.module.documentum.Utils;
import org.mule.module.documentum.coreservices.QueryClient;

public class QueryClientImpl
implements QueryClient {
    private QueryServicePort port;
    private ServiceContext serviceContext;

    public QueryClientImpl(String target, ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this.setQueryPort(target);
    }

    @Override
    public QueryResult query(String dqlStatement) throws SerializableException {
        return this.port.execute(Utils.createQuery(dqlStatement, this.serviceContext), this.createQueryExecution(CacheStrategyType.NO_CACHE_STRATEGY), null);
    }

    private QueryExecution createQueryExecution(CacheStrategyType cacheStrategyType) {
        QueryExecution queryEx = new QueryExecution();
        queryEx.setCacheStrategyType(cacheStrategyType);
        queryEx.setMaxResultCount(Integer.MAX_VALUE);
        return queryEx;
    }

    private void setQueryPort(String target) {
        QueryService queryService = new QueryService();
        queryService.setHandlerResolver(new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo info) {
                ArrayList<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add((Handler)new HeaderHandler(QueryClientImpl.this.serviceContext));
                return handlerList;
            }
        });
        this.port = queryService.getQueryServicePort();
        ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", target + "core/QueryService");
    }
}

