/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.documentum.coreservices;

import com.emc.documentum.fs.datamodel.core.DataObject;
import com.emc.documentum.fs.datamodel.core.DataPackage;
import com.emc.documentum.fs.datamodel.core.ObjectIdentity;
import com.emc.documentum.fs.datamodel.core.ObjectIdentityType;
import com.emc.documentum.fs.datamodel.core.ObjectLocation;
import com.emc.documentum.fs.datamodel.core.ObjectPath;
import com.emc.documentum.fs.datamodel.core.ReferenceRelationship;
import com.emc.documentum.fs.datamodel.core.RelationshipIntentModifier;
import com.emc.documentum.fs.datamodel.core.acl.AclIdentity;
import com.emc.documentum.fs.datamodel.core.content.BinaryContent;
import com.emc.documentum.fs.datamodel.core.content.Content;
import com.emc.documentum.fs.datamodel.core.content.ContentTransferMode;
import com.emc.documentum.fs.datamodel.core.content.DataHandlerContent;
import com.emc.documentum.fs.datamodel.core.content.UrlContent;
import com.emc.documentum.fs.datamodel.core.context.ServiceContext;
import com.emc.documentum.fs.datamodel.core.profiles.ContentProfile;
import com.emc.documentum.fs.datamodel.core.profiles.ContentTransferProfile;
import com.emc.documentum.fs.datamodel.core.profiles.DeleteProfile;
import com.emc.documentum.fs.datamodel.core.profiles.FormatFilter;
import com.emc.documentum.fs.datamodel.core.profiles.Profile;
import com.emc.documentum.fs.datamodel.core.profiles.PropertyFilterMode;
import com.emc.documentum.fs.datamodel.core.profiles.PropertyProfile;
import com.emc.documentum.fs.datamodel.core.properties.PropertySet;
import com.emc.documentum.fs.datamodel.core.properties.StringProperty;
import com.emc.documentum.fs.services.core.ObjectService;
import com.emc.documentum.fs.services.core.ObjectServicePort;
import com.emc.documentum.fs.services.core.SerializableException;
import com.emc.documentum.fs.services.core.acl.ServiceException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import org.mule.module.documentum.HeaderHandler;
import org.mule.module.documentum.Utils;
import org.mule.module.documentum.coreservices.ObjectClient;

public class ObjectClientImpl
implements ObjectClient {
    private ObjectServicePort port;
    private ServiceContext serviceContext;

    public ObjectClientImpl(String target, ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this.setObjectServicePort(target);
    }

    @Override
    public ObjectIdentity createObject(String type, String filePath, String name, String folderPath, ContentTransferMode transferMode) throws IOException, SerializableException {
        HashMap<String, String> properties = new HashMap<String, String>();
        DataObject dataObject = this.createDataObject(this.createObjectIdentity(Utils.getRepositoryName(this.serviceContext)), type);
        if (type.equals("dm_document")) {
            File file = new File(filePath);
            Utils.addContent(dataObject, transferMode, Utils.fileToByteArray(file));
            properties.put("object_name", file.getName());
            properties.put("a_content_type", file.getName().substring(file.getName().indexOf(46) + 1));
        } else {
            properties.put("object_name", name);
        }
        this.addProperties(dataObject, properties);
        dataObject.getRelationships().add(this.createRelationship(this.createFolderIdentity(Utils.getRepositoryName(this.serviceContext), this.createObjectPath(folderPath))));
        return this.port.create(this.createDataPackage(dataObject), null).getDataObjects().get(0).getIdentity();
    }

    @Override
    public ObjectIdentity createPath(String folderPath) throws SerializableException {
        return this.port.createPath(this.createObjectPath(folderPath), Utils.getRepositoryName(this.serviceContext));
    }

    @Override
    public File getObject(ObjectIdentity objectIdentity, String outputPath, ContentTransferMode transferMode) throws IOException, SerializableException {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        ContentTransferProfile contentTransferProfile = this.createContentTransferProfile(transferMode);
        ContentProfile contentProfile = this.createContentProfile(FormatFilter.ANY);
        profiles.add(contentTransferProfile);
        profiles.add(contentProfile);
        return this.contentToFile(this.port.get(Utils.createObjectIdentitySet(objectIdentity), Utils.createOperationOptions(profiles)).getDataObjects().get(0).getContents().get(0), new File(outputPath));
    }

    @Override
    public ObjectIdentity updateObject(ObjectIdentity objectIdentity, String type, String newContentFilePath, Map<String, String> newProperties, ObjectIdentity oldParentFolder, ObjectIdentity newParentFolder, ContentTransferMode transferMode) throws SerializableException, IOException {
        DataObject dataObject = this.createDataObject(objectIdentity, type);
        if (newContentFilePath != null) {
            File file = new File(newContentFilePath);
            Utils.addContent(dataObject, transferMode, Utils.fileToByteArray(file));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("object_name", file.getName());
            properties.put("a_content_type", file.getName().substring(file.getName().indexOf(46) + 1));
            this.addProperties(dataObject, properties);
        }
        if (newProperties != null) {
            this.addProperties(dataObject, newProperties);
        }
        if (oldParentFolder != null && newParentFolder != null) {
            dataObject.getRelationships().add(this.createRelationship(oldParentFolder, RelationshipIntentModifier.REMOVE));
            dataObject.getRelationships().add(this.createRelationship(newParentFolder));
        }
        return this.port.update(this.createDataPackage(dataObject), Utils.createOperationOptions(this.createPropertyProfile(PropertyFilterMode.ALL_NON_SYSTEM))).getDataObjects().get(0).getIdentity();
    }

    @Override
    public ObjectIdentity deleteObject(ObjectIdentity objectIdentity) throws SerializableException {
        this.port.delete(Utils.createObjectIdentitySet(objectIdentity), Utils.createOperationOptions(this.createDeleteProfile(true, true)));
        return objectIdentity;
    }

    @Override
    public ObjectIdentity copyObject(ObjectIdentity objectIdentity, ObjectIdentity folderIdentity) throws SerializableException {
        return this.port.copy(Utils.createObjectIdentitySet(objectIdentity), this.createObjectLocation(folderIdentity), new DataPackage(), null).getDataObjects().get(0).getIdentity();
    }

    @Override
    public ObjectIdentity moveObject(ObjectIdentity objectIdentity, ObjectIdentity toFolderIdentity, ObjectIdentity fromFolderIdentity) throws SerializableException {
        return this.port.move(Utils.createObjectIdentitySet(objectIdentity), this.createObjectLocation(fromFolderIdentity), this.createObjectLocation(toFolderIdentity), new DataPackage(), null).getDataObjects().get(0).getIdentity();
    }

    @Override
    public ObjectIdentity applyAcl(ObjectIdentity objectIdentity, AclIdentity aclIdentity) throws ServiceException, SerializableException {
        DataObject dataObject = this.createDataObject(this.createObjectIdentity(Utils.getRepositoryName(this.serviceContext)), "dm_sysobject");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("acl_domain", aclIdentity.getDomain());
        properties.put("acl_name", aclIdentity.getName());
        this.addProperties(dataObject, properties);
        this.port.update(this.createDataPackage(dataObject), null);
        return objectIdentity;
    }

    private void addProperties(DataObject dataObject, Map<String, String> properties) {
        PropertySet propertySet = new PropertySet();
        for (Map.Entry<String, String> myEntry : properties.entrySet()) {
            StringProperty objNameProperty = new StringProperty();
            objNameProperty.setName(myEntry.getKey());
            objNameProperty.setValue(myEntry.getValue());
            propertySet.getProperties().add(objNameProperty);
        }
        dataObject.setProperties(propertySet);
    }

    private ReferenceRelationship createRelationship(ObjectIdentity identity) {
        ReferenceRelationship relationship = new ReferenceRelationship();
        relationship.setName("folder");
        relationship.setTarget(identity);
        relationship.setTargetRole("parent");
        return relationship;
    }

    private ReferenceRelationship createRelationship(ObjectIdentity identity, RelationshipIntentModifier intentModifier) {
        ReferenceRelationship relationship = this.createRelationship(identity);
        relationship.setIntentModifier(intentModifier);
        return relationship;
    }

    private DataObject createDataObject(ObjectIdentity objIdentity, String type) {
        DataObject dataObject = new DataObject();
        dataObject.setIdentity(objIdentity);
        dataObject.setType(type);
        return dataObject;
    }

    private ObjectIdentity createObjectIdentity(String repositoryName) {
        ObjectIdentity objIdentity = new ObjectIdentity();
        objIdentity.setRepositoryName(repositoryName);
        return objIdentity;
    }

    private ObjectIdentity createFolderIdentity(String repositoryName, ObjectPath objectPath) {
        ObjectIdentity objIdentity = this.createObjectIdentity(repositoryName);
        objIdentity.setObjectPath(objectPath);
        objIdentity.setValueType(ObjectIdentityType.OBJECT_PATH);
        return objIdentity;
    }

    private DataPackage createDataPackage(DataObject dataObject) {
        DataPackage dataPackage = new DataPackage();
        dataPackage.getDataObjects().add(dataObject);
        return dataPackage;
    }

    private ObjectPath createObjectPath(String folderPath) {
        ObjectPath objectPath = new ObjectPath();
        objectPath.setPath(folderPath);
        return objectPath;
    }

    private ObjectLocation createObjectLocation(ObjectIdentity objectIdentity) {
        ObjectLocation location = new ObjectLocation();
        location.setIdentity(objectIdentity);
        return location;
    }

    private ContentProfile createContentProfile(FormatFilter formatFilter) {
        ContentProfile contentProfile = new ContentProfile();
        contentProfile.setFormatFilter(formatFilter);
        return contentProfile;
    }

    private ContentTransferProfile createContentTransferProfile(ContentTransferMode transferMode) {
        ContentTransferProfile contentTransferProfile = new ContentTransferProfile();
        contentTransferProfile.setTransferMode(transferMode);
        return contentTransferProfile;
    }

    private DeleteProfile createDeleteProfile(boolean isDeepDeleteFolders, boolean isDeepDeleteChildrenInFolders) {
        DeleteProfile deleteProfile = new DeleteProfile();
        deleteProfile.setIsDeepDeleteFolders(isDeepDeleteFolders);
        deleteProfile.setIsDeepDeleteChildrenInFolders(isDeepDeleteChildrenInFolders);
        return deleteProfile;
    }

    private PropertyProfile createPropertyProfile(PropertyFilterMode filterMode) {
        PropertyProfile propertyProfile = new PropertyProfile();
        propertyProfile.setFilterMode(filterMode);
        return propertyProfile;
    }

    private void downloadContent(String url, OutputStream os) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[16384];
        BufferedInputStream inputStream = new BufferedInputStream(new URL(url).openConnection().getInputStream());
        while ((bytesRead = ((InputStream)inputStream).read(buffer)) > 0) {
            os.write(buffer, 0, bytesRead);
        }
    }

    private File contentToFile(Content content, File file) throws IOException {
        InputStream inputStream;
        FileOutputStream os = new FileOutputStream(file);
        if (content instanceof UrlContent) {
            this.downloadContent(((UrlContent)content).getUrl(), os);
        } else if (content instanceof BinaryContent) {
            ((OutputStream)os).write(((BinaryContent)content).getValue());
        } else if (content instanceof DataHandlerContent && (inputStream = ((DataHandlerContent)content).getValue().getInputStream()) != null) {
            int byteRead;
            while ((byteRead = inputStream.read()) != -1) {
                ((OutputStream)os).write(byteRead);
            }
            inputStream.close();
        }
        ((OutputStream)os).close();
        return file;
    }

    private void setObjectServicePort(String target) {
        ObjectService objectService = new ObjectService();
        objectService.setHandlerResolver(new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo info) {
                ArrayList<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add((Handler)new HeaderHandler(ObjectClientImpl.this.serviceContext));
                return handlerList;
            }
        });
        this.port = objectService.getObjectServicePort();
        ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", target + "core/ObjectService");
    }
}

