/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.documentum.coreservices;

import com.emc.documentum.fs.datamodel.core.DataObject;
import com.emc.documentum.fs.datamodel.core.acl.Acl;
import com.emc.documentum.fs.datamodel.core.acl.AclEntry;
import com.emc.documentum.fs.datamodel.core.acl.AclIdentity;
import com.emc.documentum.fs.datamodel.core.acl.AclPackage;
import com.emc.documentum.fs.datamodel.core.acl.AclType;
import com.emc.documentum.fs.datamodel.core.acl.AclVisibility;
import com.emc.documentum.fs.datamodel.core.context.ServiceContext;
import com.emc.documentum.fs.datamodel.core.properties.Property;
import com.emc.documentum.fs.datamodel.core.properties.StringProperty;
import com.emc.documentum.fs.services.core.SerializableException;
import com.emc.documentum.fs.services.core.acl.AccessControlService;
import com.emc.documentum.fs.services.core.acl.AccessControlServicePort;
import com.emc.documentum.fs.services.core.acl.CoreServiceException_Exception;
import com.emc.documentum.fs.services.core.acl.ServiceException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import org.mule.module.documentum.HeaderHandler;
import org.mule.module.documentum.Utils;
import org.mule.module.documentum.coreservices.AccessControlClient;
import org.mule.module.documentum.coreservices.QueryClient;

public class AccessControlClientImpl
implements AccessControlClient {
    private AccessControlServicePort port;
    private ServiceContext serviceContext;

    public AccessControlClientImpl(String target, ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this.setAccessControlPort(target);
    }

    @Override
    public Acl createAcl(String aclName, String aclDescription, List<AclEntry> aclEntries, AclVisibility aclVisibility, AclType aclType) throws ServiceException, CoreServiceException_Exception {
        return this.port.create(this.createAclPackage(this.createAcl(this.createAclIdentity(Utils.getRepositoryName(this.serviceContext), Utils.getUserName(this.serviceContext), aclName), aclDescription, aclType, aclVisibility, aclEntries))).getAcls().get(0);
    }

    @Override
    public AclPackage getAcl(List<String> aclNames) throws ServiceException, CoreServiceException_Exception {
        return this.port.get(this.createAclIdentityList(aclNames));
    }

    @Override
    public Acl updateAcl(String aclName, String aclDescription, List<AclEntry> aclEntries, AclVisibility aclVisibility, AclType aclType) throws ServiceException, CoreServiceException_Exception {
        return this.port.update(this.createAclPackage(this.createAcl(this.createAclIdentity(Utils.getRepositoryName(this.serviceContext), Utils.getUserName(this.serviceContext), aclName), aclDescription, aclType, aclVisibility, aclEntries))).getAcls().get(0);
    }

    @Override
    public List<String> deleteAcl(List<String> aclNames) throws ServiceException, CoreServiceException_Exception {
        this.port.delete(this.createAclIdentityList(aclNames));
        return aclNames;
    }

    @Override
    public AclPackage getAcls(QueryClient queryClient) throws ServiceException, SerializableException, CoreServiceException_Exception {
        return this.port.get(this.createAclIdentityList(this.getPropertiesValues(queryClient.query("select owner_name, object_name from dm_acl where owner_name='" + Utils.getUserName(this.serviceContext) + "'").getDataPackage().getDataObjects(), "object_name")));
    }

    private List<AclIdentity> createAclIdentityList(List<String> aclNames) {
        ArrayList<AclIdentity> aclIdentityList = new ArrayList<AclIdentity>();
        for (String aclName : aclNames) {
            aclIdentityList.add(this.createAclIdentity(Utils.getRepositoryName(this.serviceContext), Utils.getUserName(this.serviceContext), aclName));
        }
        return aclIdentityList;
    }

    private List<String> getPropertiesValues(List<DataObject> dataObjects, String propertyKey) {
        ArrayList<String> propertiesValues = new ArrayList<String>();
        block0: for (DataObject dataObject : dataObjects) {
            List<Property> properties = dataObject.getProperties().getProperties();
            for (Property property : properties) {
                if (!property.getName().equals(propertyKey)) continue;
                propertiesValues.add(((StringProperty)property).getValue());
                continue block0;
            }
        }
        return propertiesValues;
    }

    private AclIdentity createAclIdentity(String repositoryName, String userName, String aclName) {
        AclIdentity aclIdentity = new AclIdentity();
        aclIdentity.setRepositoryName(repositoryName);
        aclIdentity.setDomain(userName);
        aclIdentity.setName(aclName);
        return aclIdentity;
    }

    private Acl createAcl(AclIdentity aclIdentity, String aclDescription, AclType aclType, AclVisibility aclVisibility, List<AclEntry> aclEntries) {
        Acl acl = new Acl();
        acl.setIdentity(aclIdentity);
        acl.setDescription(aclDescription);
        acl.setSystemCreated(false);
        acl.setType(aclType);
        acl.setVisibility(aclVisibility);
        acl.getEntries().addAll(aclEntries);
        return acl;
    }

    private AclPackage createAclPackage(Acl acl) {
        AclPackage aclPackage = new AclPackage();
        ArrayList<Acl> aclList = new ArrayList<Acl>();
        aclList.add(acl);
        aclPackage.getAcls().addAll(aclList);
        return aclPackage;
    }

    private void setAccessControlPort(String target) {
        AccessControlService accessControlService = new AccessControlService();
        accessControlService.setHandlerResolver(new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo info) {
                ArrayList<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add((Handler)new HeaderHandler(AccessControlClientImpl.this.serviceContext));
                return handlerList;
            }
        });
        this.port = accessControlService.getAccessControlServicePort();
        ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", target + "core/AccessControlService");
    }
}

