/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.documentum.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.module.documentum.adapters.DocumentumConnectorConnectionIdentifierAdapter;
import org.mule.module.documentum.connectivity.DocumentumConnectorConnectionKey;
import org.mule.module.documentum.connectivity.DocumentumConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentumConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(DocumentumConnectorConnectionFactory.class);
    private DocumentumConnectorConnectionManager connectionManager;

    public DocumentumConnectorConnectionFactory(DocumentumConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof DocumentumConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        DocumentumConnectorConnectionIdentifierAdapter connector = new DocumentumConnectorConnectionIdentifierAdapter();
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof DocumentumConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof DocumentumConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            ((DocumentumConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((DocumentumConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((DocumentumConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof DocumentumConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            return ((DocumentumConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof DocumentumConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof DocumentumConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((DocumentumConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((DocumentumConnectorConnectionIdentifierAdapter)obj).connect(((DocumentumConnectorConnectionKey)key).getUsername(), ((DocumentumConnectorConnectionKey)key).getPassword(), ((DocumentumConnectorConnectionKey)key).getRepository(), ((DocumentumConnectorConnectionKey)key).getServer());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

