/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.documentum;

import com.emc.documentum.fs.datamodel.core.context.ServiceContext;
import java.security.SecureRandom;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.mule.module.documentum.Utils;

public class HeaderHandler
implements SOAPHandler<SOAPMessageContext> {
    ServiceContext context;

    public HeaderHandler(ServiceContext context) {
        this.context = context;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        this.doIt(smc);
        return true;
    }

    public boolean handleFault(SOAPMessageContext smc) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    private void doIt(SOAPMessageContext smc) {
        Boolean outboundProperty = false;
        outboundProperty = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundProperty.booleanValue()) {
            SOAPMessage message = smc.getMessage();
            try {
                SOAPPart part = message.getSOAPPart();
                SOAPEnvelope envelope = part.getEnvelope();
                SOAPHeader soapHeader = envelope.addHeader();
                SOAPElement sc = soapHeader.addChildElement("ServiceContext", "", "http://context.core.datamodel.fs.documentum.emc.com/");
                sc.addNamespaceDeclaration("", "http://context.core.datamodel.fs.documentum.emc.com/");
                SecureRandom secureRandom = new SecureRandom();
                int seedByteCount = 20;
                byte[] seed = secureRandom.generateSeed(seedByteCount);
                secureRandom.setSeed(seed);
                String random = String.valueOf(secureRandom.nextLong());
                sc.addAttribute(new QName("token"), "temporary/127.0.0.1-" + String.valueOf(System.currentTimeMillis()) + "-" + random);
                SOAPElement identity = sc.addChildElement("Identities", "", "http://context.core.datamodel.fs.documentum.emc.com/");
                identity.addAttribute(new QName("xsi:type"), "RepositoryIdentity");
                identity.addAttribute(new QName("password"), Utils.getPassword(this.context));
                identity.addAttribute(new QName("repositoryName"), Utils.getRepositoryName(this.context));
                identity.addAttribute(new QName("userName"), Utils.getUserName(this.context));
                identity.addAttribute(new QName("xmlns:xsi"), "http://www.w3.org/2001/XMLSchema-instance");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

