/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.documentum;

import com.emc.documentum.fs.datamodel.core.CheckoutInfo;
import com.emc.documentum.fs.datamodel.core.ObjectIdentity;
import com.emc.documentum.fs.datamodel.core.VersionInfo;
import com.emc.documentum.fs.datamodel.core.VersionStrategy;
import com.emc.documentum.fs.datamodel.core.acl.Acl;
import com.emc.documentum.fs.datamodel.core.acl.AclEntry;
import com.emc.documentum.fs.datamodel.core.acl.AclIdentity;
import com.emc.documentum.fs.datamodel.core.acl.AclPackage;
import com.emc.documentum.fs.datamodel.core.acl.AclType;
import com.emc.documentum.fs.datamodel.core.acl.AclVisibility;
import com.emc.documentum.fs.datamodel.core.content.ContentTransferMode;
import com.emc.documentum.fs.datamodel.core.context.RepositoryIdentity;
import com.emc.documentum.fs.datamodel.core.context.ServiceContext;
import com.emc.documentum.fs.datamodel.core.query.QueryResult;
import com.emc.documentum.fs.services.core.SerializableException;
import com.emc.documentum.fs.services.core.acl.CoreServiceException_Exception;
import com.emc.documentum.fs.services.core.acl.ServiceException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.mule.api.ConnectionException;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.InvalidateConnectionOn;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.display.Password;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.module.documentum.DocumentumConnectorException;
import org.mule.module.documentum.coreservices.AccessControlClient;
import org.mule.module.documentum.coreservices.AccessControlClientImpl;
import org.mule.module.documentum.coreservices.ObjectClient;
import org.mule.module.documentum.coreservices.ObjectClientImpl;
import org.mule.module.documentum.coreservices.QueryClient;
import org.mule.module.documentum.coreservices.QueryClientImpl;
import org.mule.module.documentum.coreservices.VersionControlClient;
import org.mule.module.documentum.coreservices.VersionControlClientImpl;

@Connector(name="documentum", schemaVersion="1.0", friendlyName="Documentum")
public class DocumentumConnector {
    private static final String APIURL = "/services/";
    private String server;
    private RepositoryIdentity identity;
    private ServiceContext context;
    private AccessControlClient accessControlClient;
    private ObjectClient objectClient;
    private QueryClient queryClient;
    private VersionControlClient versionControlClient;

    @Connect
    public void connect(@ConnectionKey String username, @Password String password, String repository, String server) throws ConnectionException {
        this.identity = new RepositoryIdentity();
        this.context = new ServiceContext();
        this.identity.setUserName(username);
        this.identity.setPassword(password);
        this.identity.setRepositoryName(repository);
        this.context.getIdentities().add(this.identity);
        this.setServer(server);
    }

    @Disconnect
    public void disconnect() {
        this.accessControlClient = null;
        this.objectClient = null;
        this.queryClient = null;
        this.versionControlClient = null;
    }

    @ValidateConnection
    public boolean isConnected() {
        return this.accessControlClient != null || this.objectClient != null || this.queryClient != null || this.versionControlClient != null;
    }

    @ConnectionIdentifier
    public String connectionId() {
        return this.identity.getUserName();
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity createDocument(String filePath, String folderPath, @Optional @Default(value="MTOM") ContentTransferMode transferMode) throws IOException, SerializableException {
        return this.getObjectClient().createObject("dm_document", filePath, null, folderPath, transferMode);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity createFolder(String folderName, String folderPath) throws IOException, SerializableException {
        return this.getObjectClient().createObject("dm_folder", null, folderName, folderPath, null);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity createPath(String folderPath) throws SerializableException {
        return this.getObjectClient().createPath(folderPath);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public File getObject(@Optional @Default(value="#[payload]") ObjectIdentity objectIdentity, String outputPath, ContentTransferMode transferMode) throws SerializableException, IOException {
        return this.getObjectClient().getObject(objectIdentity, outputPath, transferMode);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity updateDocument(@Optional @Default(value="#[payload]") ObjectIdentity objectIdentity, @Optional String newContentFilePath, @Optional @Default(value="MTOM") ContentTransferMode transferMode, @Optional Map<String, String> newProperties, @Optional ObjectIdentity oldParentFolder, @Optional ObjectIdentity newParentFolder) throws SerializableException, IOException {
        return this.getObjectClient().updateObject(objectIdentity, "dm_document", newContentFilePath, newProperties, oldParentFolder, newParentFolder, transferMode);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity updateFolder(@Optional @Default(value="#[payload]") ObjectIdentity objectIdentity, @Optional Map<String, String> newProperties, @Optional ObjectIdentity oldParentFolder, @Optional ObjectIdentity newParentFolder) throws SerializableException, IOException {
        return this.getObjectClient().updateObject(objectIdentity, "dm_folder", null, newProperties, oldParentFolder, newParentFolder, null);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity deleteObject(@Optional @Default(value="#[payload]") ObjectIdentity objectIdentity) throws SerializableException {
        return this.getObjectClient().deleteObject(objectIdentity);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity copyObject(@Optional @Default(value="#[payload]") ObjectIdentity objectIdentity, ObjectIdentity folderIdentity) throws SerializableException {
        return this.getObjectClient().copyObject(objectIdentity, folderIdentity);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity moveObject(@Optional @Default(value="#[payload]") ObjectIdentity objectIdentity, ObjectIdentity toFolderIdentity, ObjectIdentity fromFolderIdentity) throws SerializableException {
        return this.getObjectClient().moveObject(objectIdentity, toFolderIdentity, fromFolderIdentity);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public CheckoutInfo getCheckoutInfo(@Optional @Default(value="#[payload]") ObjectIdentity objIdentity) throws SerializableException {
        return this.getVersionControlClient().getCheckoutInfo(objIdentity);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity checkout(@Optional @Default(value="#[payload]") ObjectIdentity objIdentity) throws SerializableException {
        return this.getVersionControlClient().checkout(objIdentity);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity checkin(@Optional @Default(value="#[payload]") ObjectIdentity objIdentity, String newContentPath, @Optional @Default(value="NEXT_MINOR") VersionStrategy versionStrategy, List<String> labels, @Optional @Default(value="false") boolean isRetainLock, @Optional @Default(value="MTOM") ContentTransferMode transferMode) throws SerializableException, IOException {
        return this.getVersionControlClient().checkin(objIdentity, newContentPath, versionStrategy, labels, isRetainLock, transferMode);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity cancelCheckout(@Optional @Default(value="#[payload]") ObjectIdentity objIdentity) throws SerializableException {
        return this.getVersionControlClient().cancelCheckout(objIdentity);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity deleteVersion(@Optional @Default(value="#[payload]") ObjectIdentity objIdentity) throws SerializableException {
        return this.getVersionControlClient().deleteVersion(objIdentity);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity deleteAllVersions(@Optional @Default(value="#[payload]") ObjectIdentity objIdentity) throws SerializableException {
        return this.getVersionControlClient().deleteAllVersions(objIdentity);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity getCurrent(@Optional @Default(value="#[payload]") ObjectIdentity objIdentity) throws SerializableException {
        return this.getVersionControlClient().getCurrent(objIdentity);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public VersionInfo getVersionInfo(@Optional @Default(value="#[payload]") ObjectIdentity objIdentity) throws SerializableException {
        return this.getVersionControlClient().getVersionInfo(objIdentity);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public QueryResult query(String dqlStatement) throws SerializableException {
        return this.getQueryClient().query(dqlStatement);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public Acl createAcl(String aclName, String aclDescription, List<AclEntry> aclEntries, AclVisibility aclVisibility, AclType aclType) throws ServiceException, CoreServiceException_Exception {
        return this.getAccessControlClient().createAcl(aclName, aclDescription, aclEntries, aclVisibility, aclType);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public AclPackage getAcl(List<String> aclNames) throws ServiceException, CoreServiceException_Exception {
        return this.getAccessControlClient().getAcl(aclNames);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public Acl updateAcl(String aclName, String aclDescription, List<AclEntry> aclEntries, AclVisibility aclVisibility, AclType aclType) throws ServiceException, CoreServiceException_Exception {
        return this.getAccessControlClient().updateAcl(aclName, aclDescription, aclEntries, aclVisibility, aclType);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public List<String> deleteAcl(List<String> aclNames) throws ServiceException, CoreServiceException_Exception {
        return this.getAccessControlClient().deleteAcl(aclNames);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public ObjectIdentity applyAcl(ObjectIdentity objectIdentity, AclIdentity aclIdentity) throws ServiceException, SerializableException {
        return this.getObjectClient().applyAcl(objectIdentity, aclIdentity);
    }

    @Processor
    @InvalidateConnectionOn(exception=DocumentumConnectorException.class)
    public AclPackage getAcls() throws ServiceException, SerializableException, CoreServiceException_Exception {
        return this.getAccessControlClient().getAcls(this.getQueryClient());
    }

    public String getApiUrl() {
        return APIURL;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        if (!server.startsWith("http://")) {
            server = "http://" + server;
        }
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        this.server = server;
    }

    public RepositoryIdentity getIdentity() {
        return this.identity;
    }

    public void setIdentity(RepositoryIdentity identity) {
        this.identity = identity;
    }

    public ServiceContext getContext() {
        return this.context;
    }

    public void setContext(ServiceContext context) {
        this.context = context;
    }

    public String getTarget() {
        return this.getServer() + this.getApiUrl();
    }

    public AccessControlClient getAccessControlClient() {
        if (this.accessControlClient != null) {
            return this.accessControlClient;
        }
        this.accessControlClient = new AccessControlClientImpl(this.getTarget(), this.context);
        return this.accessControlClient;
    }

    public ObjectClient getObjectClient() {
        if (this.objectClient != null) {
            return this.objectClient;
        }
        this.objectClient = new ObjectClientImpl(this.getTarget(), this.context);
        return this.objectClient;
    }

    public QueryClient getQueryClient() {
        if (this.queryClient != null) {
            return this.queryClient;
        }
        this.queryClient = new QueryClientImpl(this.getTarget(), this.context);
        return this.queryClient;
    }

    public VersionControlClient getVersionControlClient() {
        if (this.versionControlClient != null) {
            return this.versionControlClient;
        }
        this.versionControlClient = new VersionControlClientImpl(this.getTarget(), this.context);
        return this.versionControlClient;
    }
}

