
package org.mule.module.documentum.processors;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import com.emc.documentum.fs.datamodel.core.acl.AclEntry;
import com.emc.documentum.fs.datamodel.core.acl.AclType;
import com.emc.documentum.fs.datamodel.core.acl.AclVisibility;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.documentum.DocumentumConnector;
import org.mule.module.documentum.DocumentumConnectorException;
import org.mule.module.documentum.connectivity.DocumentumConnectorConnectionManager;


/**
 * UpdateAclMessageProcessor invokes the {@link org.mule.module.documentum.DocumentumConnector#updateAcl(java.lang.String, java.lang.String, java.util.List, com.emc.documentum.fs.datamodel.core.acl.AclVisibility, com.emc.documentum.fs.datamodel.core.acl.AclType)} method in {@link DocumentumConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-04-09T10:45:07-03:00", comments = "Build UNNAMED.1377.fd7d4f9")
public class UpdateAclMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object aclName;
    protected String _aclNameType;
    protected Object aclDescription;
    protected String _aclDescriptionType;
    protected Object aclEntries;
    protected List<AclEntry> _aclEntriesType;
    protected Object aclVisibility;
    protected AclVisibility _aclVisibilityType;
    protected Object aclType;
    protected AclType _aclTypeType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets aclName
     * 
     * @param value Value to set
     */
    public void setAclName(Object value) {
        this.aclName = value;
    }

    /**
     * Sets aclType
     * 
     * @param value Value to set
     */
    public void setAclType(Object value) {
        this.aclType = value;
    }

    /**
     * Sets aclEntries
     * 
     * @param value Value to set
     */
    public void setAclEntries(Object value) {
        this.aclEntries = value;
    }

    /**
     * Sets aclDescription
     * 
     * @param value Value to set
     */
    public void setAclDescription(Object value) {
        this.aclDescription = value;
    }

    /**
     * Sets aclVisibility
     * 
     * @param value Value to set
     */
    public void setAclVisibility(Object value) {
        this.aclVisibility = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(DocumentumConnectorConnectionManager.class, true, event);
            final String _transformedAclName = ((String) evaluateAndTransform(getMuleContext(), event, UpdateAclMessageProcessor.class.getDeclaredField("_aclNameType").getGenericType(), null, aclName));
            final String _transformedAclDescription = ((String) evaluateAndTransform(getMuleContext(), event, UpdateAclMessageProcessor.class.getDeclaredField("_aclDescriptionType").getGenericType(), null, aclDescription));
            final List<AclEntry> _transformedAclEntries = ((List<AclEntry> ) evaluateAndTransform(getMuleContext(), event, UpdateAclMessageProcessor.class.getDeclaredField("_aclEntriesType").getGenericType(), null, aclEntries));
            final AclVisibility _transformedAclVisibility = ((AclVisibility) evaluateAndTransform(getMuleContext(), event, UpdateAclMessageProcessor.class.getDeclaredField("_aclVisibilityType").getGenericType(), null, aclVisibility));
            final AclType _transformedAclType = ((AclType) evaluateAndTransform(getMuleContext(), event, UpdateAclMessageProcessor.class.getDeclaredField("_aclTypeType").getGenericType(), null, aclType));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {DocumentumConnectorException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((DocumentumConnector) object).updateAcl(_transformedAclName, _transformedAclDescription, _transformedAclEntries, _transformedAclVisibility, _transformedAclType);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("updateAcl"), event, e);
        }
    }

}
