
package org.mule.module.documentum.processors;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import com.emc.documentum.fs.datamodel.core.ObjectIdentity;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.documentum.DocumentumConnector;
import org.mule.module.documentum.DocumentumConnectorException;
import org.mule.module.documentum.connectivity.DocumentumConnectorConnectionManager;


/**
 * MoveObjectMessageProcessor invokes the {@link org.mule.module.documentum.DocumentumConnector#moveObject(com.emc.documentum.fs.datamodel.core.ObjectIdentity, com.emc.documentum.fs.datamodel.core.ObjectIdentity, com.emc.documentum.fs.datamodel.core.ObjectIdentity)} method in {@link DocumentumConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-04-09T10:45:07-03:00", comments = "Build UNNAMED.1377.fd7d4f9")
public class MoveObjectMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object objectIdentity;
    protected ObjectIdentity _objectIdentityType;
    protected Object toFolderIdentity;
    protected ObjectIdentity _toFolderIdentityType;
    protected Object fromFolderIdentity;
    protected ObjectIdentity _fromFolderIdentityType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets toFolderIdentity
     * 
     * @param value Value to set
     */
    public void setToFolderIdentity(Object value) {
        this.toFolderIdentity = value;
    }

    /**
     * Sets fromFolderIdentity
     * 
     * @param value Value to set
     */
    public void setFromFolderIdentity(Object value) {
        this.fromFolderIdentity = value;
    }

    /**
     * Sets objectIdentity
     * 
     * @param value Value to set
     */
    public void setObjectIdentity(Object value) {
        this.objectIdentity = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(DocumentumConnectorConnectionManager.class, true, event);
            final ObjectIdentity _transformedObjectIdentity = ((ObjectIdentity) evaluateAndTransform(getMuleContext(), event, MoveObjectMessageProcessor.class.getDeclaredField("_objectIdentityType").getGenericType(), null, objectIdentity));
            final ObjectIdentity _transformedToFolderIdentity = ((ObjectIdentity) evaluateAndTransform(getMuleContext(), event, MoveObjectMessageProcessor.class.getDeclaredField("_toFolderIdentityType").getGenericType(), null, toFolderIdentity));
            final ObjectIdentity _transformedFromFolderIdentity = ((ObjectIdentity) evaluateAndTransform(getMuleContext(), event, MoveObjectMessageProcessor.class.getDeclaredField("_fromFolderIdentityType").getGenericType(), null, fromFolderIdentity));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {DocumentumConnectorException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((DocumentumConnector) object).moveObject(_transformedObjectIdentity, _transformedToFolderIdentity, _transformedFromFolderIdentity);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("moveObject"), event, e);
        }
    }

}
