
package org.mule.module.documentum.processors;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import com.emc.documentum.fs.datamodel.core.ObjectIdentity;
import com.emc.documentum.fs.datamodel.core.VersionStrategy;
import com.emc.documentum.fs.datamodel.core.content.ContentTransferMode;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.documentum.DocumentumConnector;
import org.mule.module.documentum.DocumentumConnectorException;
import org.mule.module.documentum.connectivity.DocumentumConnectorConnectionManager;


/**
 * CheckinMessageProcessor invokes the {@link org.mule.module.documentum.DocumentumConnector#checkin(com.emc.documentum.fs.datamodel.core.ObjectIdentity, java.lang.String, com.emc.documentum.fs.datamodel.core.VersionStrategy, java.util.List, boolean, com.emc.documentum.fs.datamodel.core.content.ContentTransferMode)} method in {@link DocumentumConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-04-09T10:45:07-03:00", comments = "Build UNNAMED.1377.fd7d4f9")
public class CheckinMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object objIdentity;
    protected ObjectIdentity _objIdentityType;
    protected Object newContentPath;
    protected String _newContentPathType;
    protected Object versionStrategy;
    protected VersionStrategy _versionStrategyType;
    protected Object labels;
    protected List<String> _labelsType;
    protected Object isRetainLock;
    protected boolean _isRetainLockType;
    protected Object transferMode;
    protected ContentTransferMode _transferModeType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets isRetainLock
     * 
     * @param value Value to set
     */
    public void setIsRetainLock(Object value) {
        this.isRetainLock = value;
    }

    /**
     * Sets transferMode
     * 
     * @param value Value to set
     */
    public void setTransferMode(Object value) {
        this.transferMode = value;
    }

    /**
     * Sets newContentPath
     * 
     * @param value Value to set
     */
    public void setNewContentPath(Object value) {
        this.newContentPath = value;
    }

    /**
     * Sets labels
     * 
     * @param value Value to set
     */
    public void setLabels(Object value) {
        this.labels = value;
    }

    /**
     * Sets objIdentity
     * 
     * @param value Value to set
     */
    public void setObjIdentity(Object value) {
        this.objIdentity = value;
    }

    /**
     * Sets versionStrategy
     * 
     * @param value Value to set
     */
    public void setVersionStrategy(Object value) {
        this.versionStrategy = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(DocumentumConnectorConnectionManager.class, true, event);
            final ObjectIdentity _transformedObjIdentity = ((ObjectIdentity) evaluateAndTransform(getMuleContext(), event, CheckinMessageProcessor.class.getDeclaredField("_objIdentityType").getGenericType(), null, objIdentity));
            final String _transformedNewContentPath = ((String) evaluateAndTransform(getMuleContext(), event, CheckinMessageProcessor.class.getDeclaredField("_newContentPathType").getGenericType(), null, newContentPath));
            final VersionStrategy _transformedVersionStrategy = ((VersionStrategy) evaluateAndTransform(getMuleContext(), event, CheckinMessageProcessor.class.getDeclaredField("_versionStrategyType").getGenericType(), null, versionStrategy));
            final List<String> _transformedLabels = ((List<String> ) evaluateAndTransform(getMuleContext(), event, CheckinMessageProcessor.class.getDeclaredField("_labelsType").getGenericType(), null, labels));
            final Boolean _transformedIsRetainLock = ((Boolean) evaluateAndTransform(getMuleContext(), event, CheckinMessageProcessor.class.getDeclaredField("_isRetainLockType").getGenericType(), null, isRetainLock));
            final ContentTransferMode _transformedTransferMode = ((ContentTransferMode) evaluateAndTransform(getMuleContext(), event, CheckinMessageProcessor.class.getDeclaredField("_transferModeType").getGenericType(), null, transferMode));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {DocumentumConnectorException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((DocumentumConnector) object).checkin(_transformedObjIdentity, _transformedNewContentPath, _transformedVersionStrategy, _transformedLabels, _transformedIsRetainLock, _transformedTransferMode);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("checkin"), event, e);
        }
    }

}
