/**
 *
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

/**
 * This file was automatically generated by the Mule Development Kit
 */

package org.mule.module.documentum.coreservices;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.mule.module.documentum.Utils;
import org.mule.module.documentum.HeaderHandler;

import com.emc.documentum.fs.datamodel.core.CheckoutInfo;
import com.emc.documentum.fs.datamodel.core.DataPackage;
import com.emc.documentum.fs.datamodel.core.ObjectIdentity;
import com.emc.documentum.fs.datamodel.core.ObjectIdentitySet;
import com.emc.documentum.fs.datamodel.core.OperationOptions;
import com.emc.documentum.fs.datamodel.core.VersionInfo;
import com.emc.documentum.fs.datamodel.core.VersionStrategy;
import com.emc.documentum.fs.datamodel.core.content.ContentTransferMode;
import com.emc.documentum.fs.datamodel.core.context.ServiceContext;
import com.emc.documentum.fs.datamodel.core.profiles.ContentProfile;
import com.emc.documentum.fs.datamodel.core.profiles.FormatFilter;
import com.emc.documentum.fs.datamodel.core.profiles.PageFilter;
import com.emc.documentum.fs.datamodel.core.profiles.PageModifierFilter;
import com.emc.documentum.fs.services.core.SerializableException;
import com.emc.documentum.fs.services.core.VersionControlService;
import com.emc.documentum.fs.services.core.VersionControlServicePort;

public class VersionControlClientImpl implements VersionControlClient {
    
    private VersionControlServicePort port;
    private ServiceContext serviceContext;

    public VersionControlClientImpl(String target, ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        setVersionControlPort(target);
    }
    
    public CheckoutInfo getCheckoutInfo(ObjectIdentity objIdentity) throws SerializableException {
        ObjectIdentitySet objIdSet = Utils.createObjectIdentitySet(objIdentity);
        port.checkout(objIdSet, null);
        CheckoutInfo checkoutInfo = port.getCheckoutInfo(objIdSet).get(0);
        port.cancelCheckout(objIdSet);
        return checkoutInfo;
    }
    
    public ObjectIdentity checkout(ObjectIdentity objIdentity) throws SerializableException {
        return port.checkout(Utils.createObjectIdentitySet(objIdentity), null).getDataObjects().get(0).getIdentity();
    }
    
    public ObjectIdentity checkin(ObjectIdentity objIdentity, String newContentPath, VersionStrategy versionStrategy, List<String> labels, boolean isRetainLock, ContentTransferMode transferMode) throws SerializableException, IOException {
        OperationOptions operationOptions = Utils.createOperationOptions(createContentProfile(FormatFilter.ANY, PageFilter.ANY, -1, PageModifierFilter.ANY));
        DataPackage checkinPackage = port.checkout(Utils.createObjectIdentitySet(objIdentity), operationOptions);
        checkinPackage.getDataObjects().get(0).getContents().clear();        
        Utils.addContent(checkinPackage.getDataObjects().get(0), transferMode, Utils.fileToByteArray(new File(newContentPath)));
        return port.checkin(checkinPackage, versionStrategy, isRetainLock, labels, operationOptions).getDataObjects().get(0).getIdentity();
    }
    
    public ObjectIdentity cancelCheckout(ObjectIdentity objIdentity) throws SerializableException {
        port.cancelCheckout(Utils.createObjectIdentitySet(objIdentity));
        return objIdentity;
    }
    
    public ObjectIdentity deleteVersion(ObjectIdentity objIdentity) throws SerializableException {
        port.deleteVersion(Utils.createObjectIdentitySet(objIdentity));
        return objIdentity;
    }
    
    public ObjectIdentity deleteAllVersions(ObjectIdentity objIdentity) throws SerializableException {
        port.deleteAllVersions(Utils.createObjectIdentitySet(objIdentity));
        return objIdentity;
    }
    
    public ObjectIdentity getCurrent(ObjectIdentity objIdentity) throws SerializableException {
        return port.getCurrent(Utils.createObjectIdentitySet(objIdentity), null).getDataObjects().get(0).getIdentity();
    }
    
    public VersionInfo getVersionInfo(ObjectIdentity objIdentity) throws SerializableException {
        return port.getVersionInfo(Utils.createObjectIdentitySet(objIdentity)).get(0);
    }
    
    private ContentProfile createContentProfile(FormatFilter formatFilter, PageFilter pageFilter, int pageNumber, PageModifierFilter pageModifierFilter) {
        ContentProfile contentProfile = new ContentProfile();
        contentProfile.setFormatFilter(formatFilter);
        contentProfile.setPageFilter(pageFilter);
        contentProfile.setPageNumber(pageNumber);
        contentProfile.setPageModifierFilter(pageModifierFilter);
        return contentProfile;
    }
    
    private void setVersionControlPort(String target) {
        VersionControlService versionControlService = new VersionControlService();
        versionControlService.setHandlerResolver(new HandlerResolver() {
            @SuppressWarnings("rawtypes")
            public List<Handler> getHandlerChain(PortInfo info) {
                List<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add(new HeaderHandler(serviceContext));
                return handlerList;
            }
        });
        port = versionControlService.getVersionControlServicePort();
        ((BindingProvider) port).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, target + "core/VersionControlService");
    }

}