/**
 *
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

/**
 * This file was automatically generated by the Mule Development Kit
 */

package org.mule.module.documentum.coreservices;

import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.mule.module.documentum.Utils;
import org.mule.module.documentum.HeaderHandler;

import com.emc.documentum.fs.datamodel.core.CacheStrategyType;
import com.emc.documentum.fs.datamodel.core.context.ServiceContext;
import com.emc.documentum.fs.datamodel.core.query.QueryExecution;
import com.emc.documentum.fs.datamodel.core.query.QueryResult;
import com.emc.documentum.fs.services.core.QueryService;
import com.emc.documentum.fs.services.core.QueryServicePort;
import com.emc.documentum.fs.services.core.SerializableException;

public class QueryClientImpl implements QueryClient {
    
    private QueryServicePort port;
    private ServiceContext serviceContext;
    
    public QueryClientImpl(String target, ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        setQueryPort(target);
    }
    
    public QueryResult query(String dqlStatement) throws SerializableException {
        return port.execute(Utils.createQuery(dqlStatement, serviceContext), createQueryExecution(CacheStrategyType.NO_CACHE_STRATEGY), null);
    }
    
    private QueryExecution createQueryExecution(CacheStrategyType cacheStrategyType) {
        QueryExecution queryEx = new QueryExecution();
        queryEx.setCacheStrategyType(cacheStrategyType);
        queryEx.setMaxResultCount(Integer.MAX_VALUE);
        return queryEx;
    }
    
    private void setQueryPort(String target) {
        QueryService queryService = new QueryService();
        queryService.setHandlerResolver(new HandlerResolver() {
            @SuppressWarnings("rawtypes")
            public List<Handler> getHandlerChain(PortInfo info) {
                List<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add(new HeaderHandler(serviceContext));
                return handlerList;
            }
        });
        port = queryService.getQueryServicePort();
        ((BindingProvider) port).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, target + "core/QueryService");
    }

}