/**
 *
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

/**
 * This file was automatically generated by the Mule Development Kit
 */

package org.mule.module.documentum.coreservices;

import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.mule.module.documentum.Utils;
import org.mule.module.documentum.HeaderHandler;

import com.emc.documentum.fs.datamodel.core.DataObject;
import com.emc.documentum.fs.datamodel.core.acl.Acl;
import com.emc.documentum.fs.datamodel.core.acl.AclEntry;
import com.emc.documentum.fs.datamodel.core.acl.AclIdentity;
import com.emc.documentum.fs.datamodel.core.acl.AclPackage;
import com.emc.documentum.fs.datamodel.core.acl.AclType;
import com.emc.documentum.fs.datamodel.core.acl.AclVisibility;
import com.emc.documentum.fs.datamodel.core.context.ServiceContext;
import com.emc.documentum.fs.datamodel.core.properties.Property;
import com.emc.documentum.fs.datamodel.core.properties.StringProperty;
import com.emc.documentum.fs.services.core.SerializableException;
import com.emc.documentum.fs.services.core.acl.AccessControlService;
import com.emc.documentum.fs.services.core.acl.AccessControlServicePort;
import com.emc.documentum.fs.services.core.acl.CoreServiceException_Exception;
import com.emc.documentum.fs.services.core.acl.ServiceException;

public class AccessControlClientImpl implements AccessControlClient {
    
    private AccessControlServicePort port;
    private ServiceContext serviceContext;
    
    public AccessControlClientImpl(String target, ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        setAccessControlPort(target);
    }
    
    public Acl createAcl(String aclName, String aclDescription, List<AclEntry> aclEntries, AclVisibility aclVisibility, AclType aclType) throws ServiceException, CoreServiceException_Exception {        
        return port.create(createAclPackage(createAcl(createAclIdentity(Utils.getRepositoryName(serviceContext), Utils.getUserName(serviceContext), aclName), aclDescription, aclType, aclVisibility, aclEntries))).getAcls().get(0);
    }
    
    public AclPackage getAcl(List<String> aclNames) throws ServiceException, CoreServiceException_Exception {
        return port.get(createAclIdentityList(aclNames));
    }
    
    public Acl updateAcl(String aclName, String aclDescription, List<AclEntry> aclEntries, AclVisibility aclVisibility, AclType aclType) throws ServiceException, CoreServiceException_Exception {        
        return port.update(createAclPackage(createAcl(createAclIdentity(Utils.getRepositoryName(serviceContext), Utils.getUserName(serviceContext), aclName), aclDescription, aclType, aclVisibility, aclEntries))).getAcls().get(0);
    }
    
    public List<String> deleteAcl(List<String> aclNames) throws ServiceException, CoreServiceException_Exception {
        port.delete(createAclIdentityList(aclNames));
        return aclNames;
    }
    
    public AclPackage getAcls(QueryClient queryClient) throws ServiceException, SerializableException, CoreServiceException_Exception {
        return port.get(createAclIdentityList(getPropertiesValues(queryClient.query(("select owner_name, object_name from dm_acl where owner_name='" + Utils.getUserName(serviceContext) + "'")).getDataPackage().getDataObjects(), "object_name")));
    }
    
    private List<AclIdentity> createAclIdentityList(List<String> aclNames) {
        List<AclIdentity> aclIdentityList = new ArrayList<AclIdentity>();
        for (String aclName: aclNames) {
            aclIdentityList.add(createAclIdentity(Utils.getRepositoryName(serviceContext), Utils.getUserName(serviceContext), aclName));
        }
        return aclIdentityList;
    }
    
    private List<String> getPropertiesValues(List<DataObject> dataObjects, String propertyKey) {
        List<String> propertiesValues = new ArrayList<String>();
        for (DataObject dataObject : dataObjects) {
            List<Property> properties = dataObject.getProperties().getProperties();
            for (Property property : properties) {
                if (property.getName().equals(propertyKey)) { 
                    propertiesValues.add(((StringProperty) property).getValue());
                    break;
                }
            }
        }
        return propertiesValues;
    }
    
    private AclIdentity createAclIdentity(String repositoryName, String userName, String aclName) {
        AclIdentity aclIdentity = new AclIdentity();
        aclIdentity.setRepositoryName(repositoryName);
        aclIdentity.setDomain(userName);
        aclIdentity.setName(aclName);
        return aclIdentity;
    }
    
    private Acl createAcl(AclIdentity aclIdentity, String aclDescription, AclType aclType, AclVisibility aclVisibility, List<AclEntry> aclEntries) {
        Acl acl = new Acl();
        acl.setIdentity(aclIdentity);
        acl.setDescription(aclDescription);
        acl.setSystemCreated(false);
        acl.setType(aclType);
        acl.setVisibility(aclVisibility);
        acl.getEntries().addAll(aclEntries);
        return acl;
    }
    
    private AclPackage createAclPackage(Acl acl) {
        AclPackage aclPackage = new AclPackage();
        List<Acl> aclList = new ArrayList<Acl>();
        aclList.add(acl);
        aclPackage.getAcls().addAll(aclList);
        return aclPackage;
    }
    
    private void setAccessControlPort(String target) {
        AccessControlService accessControlService = new AccessControlService();
        accessControlService.setHandlerResolver(new HandlerResolver() {
            @SuppressWarnings("rawtypes")
            public List<Handler> getHandlerChain(PortInfo info) {
                List<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add(new HeaderHandler(serviceContext));
                return handlerList;
            }
        });
        port = accessControlService.getAccessControlServicePort();
        ((BindingProvider) port).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, target + "core/AccessControlService");
    }
    
}