/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.util.FileUtils;
import org.mule.runtime.core.util.FilenameUtils;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.DeploymentInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactArchiveInstaller {
    protected static final String ANCHOR_FILE_BLURB = "Delete this file while Mule is running to remove the artifact in a clean way.";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final File artifactParentDir;

    public ArtifactArchiveInstaller(File artifactParentDir) {
        this.artifactParentDir = artifactParentDir;
    }

    public File installArtifact(URL artifactUrl) throws IOException {
        if (!artifactUrl.toString().endsWith(".zip")) {
            throw new IllegalArgumentException("Invalid Mule artifact archive: " + artifactUrl);
        }
        String baseName = FilenameUtils.getBaseName((String)artifactUrl.toString());
        if (baseName.contains("%20")) {
            throw new DeploymentInitException(I18nMessageFactory.createStaticMessage((String)("Mule artifact name may not contain spaces: " + baseName)));
        }
        File artifactDir = null;
        boolean errorEncountered = false;
        try {
            String fullPath = artifactUrl.toURI().toString();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Exploding a Mule artifact archive: " + fullPath);
            }
            String artifactName = FilenameUtils.getBaseName((String)fullPath);
            artifactDir = new File(this.artifactParentDir, artifactName);
            File source = new File(artifactUrl.toURI());
            FileUtils.unzip((File)source, (File)artifactDir);
            if ("file".equals(artifactUrl.getProtocol())) {
                FileUtils.deleteQuietly((File)source);
            }
        }
        catch (URISyntaxException e) {
            errorEncountered = true;
            IOException ex = new IOException(e.getMessage());
            ex.fillInStackTrace();
            throw ex;
        }
        catch (IOException e) {
            errorEncountered = true;
            throw e;
        }
        catch (Throwable t) {
            errorEncountered = true;
            String msg = "Failed to install artifact from URL: " + artifactUrl;
            throw new DeploymentInitException(I18nMessageFactory.createStaticMessage((String)msg), t);
        }
        finally {
            if (errorEncountered && artifactDir != null && artifactDir.exists()) {
                FileUtils.deleteTree((File)artifactDir);
            }
        }
        return artifactDir;
    }

    public void desinstallArtifact(String artifactName) {
        try {
            File artifactDir = new File(this.artifactParentDir, artifactName);
            FileUtils.deleteDirectory((File)artifactDir);
            File marker = this.getArtifactAnchorFile(artifactName);
            marker.delete();
            Introspector.flushCaches();
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            String msg = String.format("Failed to undeployArtifact artifact [%s]", artifactName);
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)msg), t);
        }
    }

    private File getArtifactAnchorFile(String artifactName) {
        return new File(this.artifactParentDir, String.format("%s%s", artifactName, "-anchor.txt"));
    }

    public void createAnchorFile(String artifactName) throws IOException {
        File marker = this.getArtifactAnchorFile(artifactName);
        FileUtils.writeStringToFile((File)marker, (String)ANCHOR_FILE_BLURB);
    }
}

