/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import com.google.common.collect.LinkedListMultimap;
import java.util.Map;
import org.mule.runtime.core.util.SimpleLoggingTable;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.StartupListener;
import org.mule.runtime.module.deployment.internal.ArtifactDeploymentStatusTracker;
import org.mule.runtime.module.deployment.internal.DeploymentStatusTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupSummaryDeploymentListener
implements StartupListener {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String APPLICATION_LABEL = "APPLICATION";
    private static final String DOMAIN_OWNER_LABEL = "DOMAIN";
    private static final String STATUS_LABEL = "STATUS";
    private static final int ARTIFACT_NAME_LABEL_LENGTH = 45;
    private static final int STATUS_LABEL_LENGTH = 18;
    private static final int DOMAIN_OWNER_LABEL_LENGTH = 30;
    private static final String UNKNOWN_ARTIFACT_NAME = "UNKNOWN";
    private final DeploymentService deploymentService;
    protected DeploymentStatusTracker tracker;

    public StartupSummaryDeploymentListener(DeploymentStatusTracker tracker, DeploymentService deploymentService) {
        this.tracker = tracker;
        this.deploymentService = deploymentService;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onAfterStartup() {
        void var5_9;
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        LinkedListMultimap applicationsPerDomain = LinkedListMultimap.create();
        Map<String, ArtifactDeploymentStatusTracker.DeploymentState> domainDeploymentState = this.tracker.getDomainDeploymentStatusTracker().getDeploymentStates();
        SimpleLoggingTable domainTable = new SimpleLoggingTable();
        domainTable.addColumn(DOMAIN_OWNER_LABEL, 45);
        domainTable.addColumn(STATUS_LABEL, 18);
        for (String string : domainDeploymentState.keySet()) {
            String[] data = new String[]{string, domainDeploymentState.get(string).toString()};
            domainTable.addDataRow(data);
        }
        Map<String, ArtifactDeploymentStatusTracker.DeploymentState> applicationStates = this.tracker.getApplicationDeploymentStatusTracker().getDeploymentStates();
        for (String applicationName : applicationStates.keySet()) {
            Application application = this.deploymentService.findApplication(applicationName);
            String domainName = UNKNOWN_ARTIFACT_NAME;
            if (application != null) {
                domainName = application.getDomain().getArtifactName();
            }
            applicationsPerDomain.put((Object)domainName, (Object)applicationName);
        }
        if (!applicationsPerDomain.isEmpty()) {
            SimpleLoggingTable applicationTable = new SimpleLoggingTable();
            applicationTable.addColumn(APPLICATION_LABEL, 45);
            applicationTable.addColumn(DOMAIN_OWNER_LABEL, 30);
            applicationTable.addColumn(STATUS_LABEL, 18);
            for (String domainName : applicationsPerDomain.keySet()) {
                for (String app : applicationsPerDomain.get((Object)domainName)) {
                    String[] data = new String[]{app, domainName, applicationStates.get(app).toString()};
                    applicationTable.addDataRow(data);
                }
            }
            String string = String.format("%n%s%n%s", domainTable, applicationTable);
        } else {
            String string = String.format("%n%s", domainTable);
        }
        this.logger.info((String)var5_9);
    }
}

