/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.module.apikit.UrlUtils;

public class HttpProtocolAdapter {
    private static final char COMMA = ',';
    private static final String CONTENT_TYPE = "content-type";
    private static final String ACCEPT = "accept";
    private String basePath;
    private URI resourceURI;
    private String method;
    private String acceptableResponseMediaTypes;
    private String requestMediaType;
    private Map<String, Object> queryParams;

    public HttpProtocolAdapter(MuleEvent event) {
        String contentTypeHeaderValue;
        MuleMessage message = event.getMessage();
        this.basePath = UrlUtils.getBasePath(message);
        String hostHeader = (String)message.getInboundProperty("host");
        if (hostHeader == null) {
            throw new IllegalArgumentException("host header cannot be null");
        }
        String host = hostHeader;
        int port = 80;
        String requestPath = (String)message.getInboundProperty("http.request.path");
        if (hostHeader.contains(":")) {
            host = hostHeader.substring(0, hostHeader.indexOf(58));
            port = Integer.parseInt(hostHeader.substring(hostHeader.indexOf(58) + 1));
        }
        try {
            this.resourceURI = new URI("http", null, host, port, requestPath, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot parse URI", e);
        }
        this.method = (String)message.getInboundProperty("http.method");
        String acceptHeaderValue = this.getAsCommaSeparatedValue(message.getInboundProperty(ACCEPT));
        if (!org.mule.util.StringUtils.isBlank((String)acceptHeaderValue)) {
            this.acceptableResponseMediaTypes = acceptHeaderValue;
        }
        if (!org.mule.util.StringUtils.isBlank((String)(contentTypeHeaderValue = this.getAsCommaSeparatedValue(message.getInboundProperty(CONTENT_TYPE))))) {
            this.requestMediaType = contentTypeHeaderValue;
        }
        if (this.requestMediaType == null && !org.mule.util.StringUtils.isBlank((String)((String)message.getOutboundProperty(CONTENT_TYPE)))) {
            this.requestMediaType = (String)message.getOutboundProperty(CONTENT_TYPE);
        }
        this.queryParams = (Map)message.getInboundProperty("http.query.params");
    }

    public String getBasePath() {
        return this.basePath;
    }

    public URI getResourceURI() {
        return this.resourceURI;
    }

    public String getMethod() {
        return this.method;
    }

    public String getAcceptableResponseMediaTypes() {
        if (this.acceptableResponseMediaTypes == null) {
            return "*/*";
        }
        return this.acceptableResponseMediaTypes;
    }

    public String getRequestMediaType() {
        return this.requestMediaType != null ? this.requestMediaType.split(";")[0] : null;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    private String getAsCommaSeparatedValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            return StringUtils.join((Collection)((Collection)value), (char)',');
        }
        return (String)value;
    }
}

