/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import com.jayway.restassured.RestAssured;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class QueryParamsTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("http.port");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/validation/query-params/query-params.xml";
    }

    @Test
    public void validIntegerQueryParam() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/integer?param=1", new Object[0]);
    }

    @Test
    public void invalidIntegerQueryParam() {
        RestAssured.given().expect().statusCode(400).response().when().get("/api/integer-array?param=Hola mundo", new Object[0]);
    }

    @Test
    public void validIntegerQueryParamArray() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/integer-array?param=[1,2]", new Object[0]);
    }

    @Test
    public void InvalidIntegerQueryParamArray() {
        RestAssured.given().expect().statusCode(400).response().when().get("/api/integer-array?param=[Hola,2]", new Object[0]);
    }

    @Test
    public void validIntegerQueryParamArrayAsPairs() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/integer-array?param=1&param=2", new Object[0]);
    }

    @Test
    public void validIntegerQueryParamArrayOnlyOneValue() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/integer-array?param=1", new Object[0]);
    }

    @Test
    public void validStringQueryParam() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/string?param=Hola mundo", new Object[0]);
    }

    @Test
    public void validStringQueryParamArray() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/string-array?param=['Hola','mundo']", new Object[0]);
    }

    @Test
    public void validStringQueryParamArrayAsPairs() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/string-array?param='Hola'&param='mundo'", new Object[0]);
    }

    @Test
    public void validStringQueryParamArrayOnlyOneValue() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/string-array?param='Hola mundo'", new Object[0]);
    }

    @Test
    public void validObjectQueryParam() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/object?param={\"name\":\"Marcelo\",\"surname\":\"Gallardo\"}", new Object[0]);
    }

    @Test
    public void invalidObjectQueryParam() {
        RestAssured.given().expect().statusCode(400).response().when().get("/api/object?param=[{\"name\":\"Marcelo\",\"surname\":\"Gallardo\"}]", new Object[0]);
    }

    @Test
    public void validObjectQueryParamArray() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/object-array?param=[{\"name\":\"Marcelo\",\"surname\":\"Gallardo\"},{\"name\":\"Rafael\",\"surname\":\"Borre\"}]", new Object[0]);
    }

    @Test
    public void validObjectQueryParamArrayAsPairs() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/object-array?param={\"name\":\"Marcelo\",\"surname\":\"Gallardo\"}&param={\"name\":\"Rafael\",\"surname\":\"Borre\"}", new Object[0]);
    }

    @Test
    public void validObjectQueryParamArrayOnlyOneValue() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/object-array?param={\"name\":\"Marcelo\",\"surname\":\"Gallardo\"}", new Object[0]);
    }

    @Test
    public void invalidObjectQueryParamArrayOnlyOneValue() {
        RestAssured.given().expect().statusCode(400).response().when().get("/api/object-array?param={\"firstname\":\"Marcelo\",\"lastname\":\"Gallardo\"}", new Object[0]);
    }
}

