/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.module.apikit.exception.BadRequestException;
import org.mule.module.apikit.validation.BodyValidator;
import org.mule.raml.implv2.v10.model.MimeTypeImpl;
import org.mule.raml.interfaces.model.IMimeType;

public class BodyValidatorTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void validateBodyIsXmlWithXmlContentType() throws Exception {
        this.expected.expect(BadRequestException.class);
        this.expected.expectMessage("Expected XML body");
        BodyValidator bodyValidator = new BodyValidator((IMimeType)new MimeTypeImpl(null));
        bodyValidator.validateSchemaV2(false, "{\"test\" : \"test\"}");
    }

    @Test
    public void validateBodyIsJSONWithJSONContentType() throws Exception {
        this.expected.expect(BadRequestException.class);
        this.expected.expectMessage("Expected JSON body");
        BodyValidator bodyValidator = new BodyValidator((IMimeType)new MimeTypeImpl(null));
        bodyValidator.validateSchemaV2(true, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<data><type>pinViewTokens</type> <attributes><cardNumber>4539799524650412</cardNumber> </attributes></data>");
    }
}

