/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.util;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.MuleDeploymentService;
import org.mule.module.launcher.MulePluginClassLoaderManager;
import org.mule.module.launcher.PluginClassLoaderManager;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationStatus;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.util.FileUtils;

public class FunctionalAppDeployTestCase
extends AbstractMuleContextTestCase {
    protected static final int DEPLOYMENT_TIMEOUT = 10000;
    protected File muleHome;
    protected File appsDir;
    protected File domainsDir;
    protected MuleDeploymentService deploymentService;
    protected DeploymentListener applicationDeploymentListener;

    public void doSetUp() throws Exception {
        super.doSetUp();
        String tmpDir = System.getProperty("java.io.tmpdir");
        this.muleHome = new File(new File(tmpDir, "mule-home"), ((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis());
        this.appsDir = new File(this.muleHome, "apps");
        this.appsDir.mkdirs();
        this.domainsDir = new File(this.muleHome, "domains");
        this.domainsDir.mkdirs();
        System.setProperty("mule.home", this.muleHome.getCanonicalPath());
        new File(this.muleHome, "lib/shared/default").mkdirs();
        this.applicationDeploymentListener = (DeploymentListener)Mockito.mock(DeploymentListener.class);
        this.deploymentService = new MuleDeploymentService((PluginClassLoaderManager)new MulePluginClassLoaderManager());
        this.deploymentService.addDeploymentListener(this.applicationDeploymentListener);
    }

    public void doTearDown() throws Exception {
        if (this.deploymentService != null) {
            this.deploymentService.stop();
        }
        FileUtils.deleteTree((File)this.muleHome);
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
    }

    protected void deployExplodedApp(File appDir, String appName) throws IOException {
        File tempAppFolder = new File(this.muleHome, appName);
        FileUtils.copyDirectory((File)appDir, (File)tempAppFolder);
        File appFolder = new File(this.appsDir, appName);
        tempAppFolder.renameTo(appFolder);
    }

    protected void assertApplicationDeploymentSuccess(DeploymentListener listener, String artifactName) {
        this.assertDeploymentSuccess(listener, artifactName);
        this.assertStatus(artifactName, ApplicationStatus.STARTED);
    }

    private void assertDeploymentSuccess(final DeploymentListener listener, final String artifactName) {
        PollingProber prober = new PollingProber(10000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                ((DeploymentListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onDeploymentSuccess(artifactName);
                return true;
            }

            public String describeFailure() {
                return "Failed to deploy application: " + artifactName + System.lineSeparator() + super.describeFailure();
            }
        });
    }

    private void assertStatus(String appName, final ApplicationStatus status) {
        final Application application = this.findApp(appName);
        PollingProber prober = new PollingProber(10000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                Assert.assertThat((Object)application.getStatus(), (Matcher)Is.is((Object)status));
                return true;
            }

            public String describeFailure() {
                return String.format("Application %s was expected to be in status %s but was %s instead", application.getArtifactName(), status.name(), application.getStatus().name());
            }
        });
    }

    private Application findApp(String appName) {
        Application app = this.deploymentService.findApplication(appName);
        Assert.assertNotNull((Object)app);
        return app;
    }
}

