/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.parameters;

import com.jayway.restassured.RestAssured;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ParametersNullableTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    private static final String validateNullStringType = "apikit.validate.null.string.param";

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        System.setProperty(validateNullStringType, "true");
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigFile() {
        return "org/mule/module/apikit/parameters/parameters-10-config.xml";
    }

    @After
    public void clear() {
        System.clearProperty(validateNullStringType);
    }

    @Test
    public void stringTypeNullInvalid() {
        RestAssured.given().queryParam("string-type", new Object[]{null}).expect().response().statusCode(500).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void nullableIngerType() {
        RestAssured.given().queryParam("integer-nil-type", new Object[]{null}).expect().response().statusCode(200).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void nullableIngerTypeWithNullAsString() {
        RestAssured.given().queryParam("integer-nil-type", new Object[]{"null"}).expect().response().statusCode(200).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void nonNullableIngerType() {
        RestAssured.given().queryParam("integer-type", new Object[]{null}).expect().response().statusCode(500).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void nonNullableIngerTypeWithNullAsString() {
        RestAssured.given().queryParam("integer-type", new Object[]{"null"}).expect().response().statusCode(500).when().get("/api/repeat", new Object[0]);
    }
}

