/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.parameters;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class Parameters10TestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigFile() {
        return "org/mule/module/apikit/parameters/parameters-10-config.xml";
    }

    @Test
    public void repeatableQueryParam() {
        RestAssured.given().queryParam("status", new Object[]{"a", "b"}).expect().response().statusCode(200).body(CoreMatchers.is((Object)"parameters: ParameterMap{[status=[a, b], default=[default value]]}"), new Matcher[0]).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void failMinItemsRepeatableQueryParam() {
        RestAssured.given().queryParam("boolean-array", new Object[]{"true", "false"}).expect().response().statusCode(500).body(CoreMatchers.is((Object)"Expected min items 3 for boolean-array and got 2 (org.mule.module.apikit.exception.InvalidQueryParameterException)."), new Matcher[0]).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void failMaxItemsRepeatableQueryParam() {
        RestAssured.given().queryParam("boolean-array", new Object[]{"true", "false", "false", "true", "false"}).expect().response().statusCode(500).body(CoreMatchers.is((Object)"Expected max items 4 for boolean-array and got 5 (org.mule.module.apikit.exception.InvalidQueryParameterException)."), new Matcher[0]).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void successRepeatableQueryParam() {
        RestAssured.given().queryParam("boolean-array", new Object[]{"true", "false", "false", "true"}).expect().response().statusCode(200).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void failMinItemsUnionRepeatableQueryParam() {
        RestAssured.given().queryParam("union-boolean-array", new Object[]{"true", "false"}).expect().response().statusCode(500).body(CoreMatchers.is((Object)"- For union-boolean-array one of the union component failed: Parameter union-boolean-array is not an array\n- For union-boolean-array one of the union component failed: Expected min items 3 for union-boolean-array and got 2\n (org.mule.module.apikit.exception.InvalidQueryParameterException)."), new Matcher[0]).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void failMaxItemsUnionRepeatableQueryParam() {
        RestAssured.given().queryParam("union-boolean-array", new Object[]{"true", "false", "false", "true", "false"}).expect().response().statusCode(500).body(CoreMatchers.is((Object)"- For union-boolean-array one of the union component failed: Parameter union-boolean-array is not an array\n- For union-boolean-array one of the union component failed: Expected max items 4 for union-boolean-array and got 5\n (org.mule.module.apikit.exception.InvalidQueryParameterException)."), new Matcher[0]).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void successRepeatableUnionQueryParam() {
        RestAssured.given().queryParam("union-boolean-array", new Object[]{"true", "false", "false", "true"}).expect().response().statusCode(200).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void repeatableStringQueryParamWithAsterisk() {
        RestAssured.given().queryParam("status", new Object[]{"*a", "b"}).expect().response().statusCode(200).body(CoreMatchers.is((Object)"parameters: ParameterMap{[status=[*a, b], default=[default value]]}"), new Matcher[0]).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void arrayStringQueryParamWithInteger() {
        RestAssured.given().queryParam("status", new Object[]{"123"}).expect().response().statusCode(200).body(CoreMatchers.is((Object)"parameters: ParameterMap{[status=[123], default=[default value]]}"), new Matcher[0]).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void arrayStringQueryParamWithIntegers() {
        RestAssured.given().queryParam("status", new Object[]{"123", "456"}).expect().response().statusCode(200).body(CoreMatchers.is((Object)"parameters: ParameterMap{[status=[123, 456], default=[default value]]}"), new Matcher[0]).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void repeatableHeader() {
        RestAssured.given().header("repeatable", (Object)"a", new Object[0]).header("repeatable", (Object)"b", new Object[0]).expect().response().statusCode(200).body(CoreMatchers.is((Object)"headers: [a, b]"), new Matcher[0]).when().get("/api/repeatHeader", new Object[0]);
    }

    @Test
    public void unionString() {
        RestAssured.given().queryParam("union-string", new Object[]{"100"}).expect().response().statusCode(200).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void nilStringTypeNullValid() {
        RestAssured.given().queryParam("union-string", new Object[]{null}).expect().response().statusCode(200).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void stringTypeNullValid() {
        RestAssured.given().queryParam("string-type", new Object[]{null}).expect().response().statusCode(200).when().get("/api/repeat", new Object[0]);
    }

    @Test
    public void parameterMapAfterDefaultAdded() {
        RestAssured.given().queryParam("status", new Object[]{"a", "b"}).expect().response().statusCode(200).body(CoreMatchers.is((Object)"parameters: ParameterMap{[status=[a, b], default=[default value]]}"), new Matcher[0]).when().get("/api/repeat", new Object[0]);
    }
}

