/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.output;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.module.apikit.HttpProtocolAdapter;
import org.mule.module.apikit.OutputRepresentationHandler;
import org.mule.module.apikit.RestContentTypeParser;
import org.mule.module.apikit.exception.NotAcceptableException;
import org.mule.raml.interfaces.model.IAction;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={RestContentTypeParser.class})
public class OutputRepresentationHandlerTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void mimeTypeUpperCase() throws Exception {
        IAction action = (IAction)Mockito.mock(IAction.class);
        Mockito.when((Object)action.getResponses()).thenReturn(new HashMap());
        HttpProtocolAdapter protocolAdapter = (HttpProtocolAdapter)Mockito.mock(HttpProtocolAdapter.class);
        Mockito.when((Object)protocolAdapter.getAcceptableResponseMediaTypes()).thenReturn((Object)"*/*");
        OutputRepresentationHandler handler = new OutputRepresentationHandler(protocolAdapter, true);
        String mimeType = handler.negotiateOutputRepresentation(action, Arrays.asList("APPLICATION/JSON"));
        Assert.assertEquals((Object)mimeType, (Object)"APPLICATION/JSON");
    }

    @Test
    public void actionIsNull() throws Exception {
        HttpProtocolAdapter protocolAdapter = (HttpProtocolAdapter)Mockito.mock(HttpProtocolAdapter.class);
        OutputRepresentationHandler handler = new OutputRepresentationHandler(protocolAdapter, true);
        Assert.assertNull((Object)handler.negotiateOutputRepresentation(null, Arrays.asList("APPLICATION/JSON")));
    }

    @Test
    public void actionResponsesAreNull() throws Exception {
        IAction action = (IAction)Mockito.mock(IAction.class);
        Mockito.when((Object)action.getResponses()).thenReturn(null);
        HttpProtocolAdapter protocolAdapter = (HttpProtocolAdapter)Mockito.mock(HttpProtocolAdapter.class);
        OutputRepresentationHandler handler = new OutputRepresentationHandler(protocolAdapter, true);
        Assert.assertNull((Object)handler.negotiateOutputRepresentation(action, Arrays.asList("APPLICATION/JSON")));
    }

    @Test
    public void bestMatchIsNull() throws Exception {
        this.expected.expect(NotAcceptableException.class);
        IAction action = (IAction)Mockito.mock(IAction.class);
        Mockito.when((Object)action.getResponses()).thenReturn(new HashMap());
        HttpProtocolAdapter protocolAdapter = (HttpProtocolAdapter)Mockito.mock(HttpProtocolAdapter.class);
        Mockito.when((Object)protocolAdapter.getAcceptableResponseMediaTypes()).thenReturn((Object)"*/*");
        PowerMockito.mockStatic(RestContentTypeParser.class, (Class[])new Class[0]);
        Mockito.when((Object)RestContentTypeParser.bestMatch((List)Matchers.anyList(), (String)((String)Matchers.any(String.class)))).thenReturn(null);
        new OutputRepresentationHandler(protocolAdapter, true).negotiateOutputRepresentation(action, Arrays.asList("APPLICATION/JSON"));
    }

    @Test
    public void bestMatchIsNullNotThrowExpection() throws Exception {
        IAction action = (IAction)Mockito.mock(IAction.class);
        Mockito.when((Object)action.getResponses()).thenReturn(new HashMap());
        HttpProtocolAdapter protocolAdapter = (HttpProtocolAdapter)Mockito.mock(HttpProtocolAdapter.class);
        Mockito.when((Object)protocolAdapter.getAcceptableResponseMediaTypes()).thenReturn((Object)"*/*");
        PowerMockito.mockStatic(RestContentTypeParser.class, (Class[])new Class[0]);
        Mockito.when((Object)RestContentTypeParser.bestMatch((List)Matchers.anyList(), (String)((String)Matchers.any(String.class)))).thenReturn(null);
        Assert.assertNull((Object)new OutputRepresentationHandler(protocolAdapter, false).negotiateOutputRepresentation(action, Arrays.asList("APPLICATION/JSON")));
    }
}

