/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.console;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class StandaloneConsoleTestCase
extends FunctionalTestCase {
    private static final String CONSOLE_PATH = "/konsole";
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public DynamicPort serverPort2 = new DynamicPort("serverPort2");
    @Rule
    public DynamicPort serverPort3 = new DynamicPort("serverPort3");
    @Rule
    public DynamicPort serverPort4 = new DynamicPort("serverPort4");
    @Rule
    public DynamicPort serverPort5 = new DynamicPort("serverPort5");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/console/standalone-console-config-not-keep-base-uri.xml";
    }

    @Test
    public void console() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().response().body(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"<title>API Console</title>"), (Matcher)CoreMatchers.containsString((String)"src=\"./?\"")), new Matcher[0]).header("Content-type", "text/html").statusCode(200).when().get("/konsole/index.html", new Object[0]);
    }

    @Test
    public void consoleResource() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/css", new Object[0]).expect().response().body(CoreMatchers.containsString((String)".CodeMirror"), new Matcher[0]).header("Content-type", "text/css").statusCode(200).when().get("/konsole/styles/api-console-light-theme.css", new Object[0]);
    }

    @Test
    public void getRaml() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/raml+yaml", new Object[0]).expect().response().body(CoreMatchers.containsString((String)("baseUri: \"http://localhost:" + RestAssured.port + "/api\"")), new Matcher[0]).header("Content-type", "application/raml+yaml").statusCode(200).when().get("/api", new Object[0]);
    }

    @Test
    public void getRamlUsingConsole() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/raml+yaml", new Object[0]).expect().response().body(CoreMatchers.containsString((String)("baseUri: \"http://localhost:" + RestAssured.port + "/api\"")), new Matcher[0]).header("Content-type", "application/raml+yaml").statusCode(200).when().get(CONSOLE_PATH, new Object[0]);
    }

    @Test
    public void consoleNoPath() throws Exception {
        RestAssured.given().port(this.serverPort2.getNumber()).header("Accept", (Object)"text/html", new Object[0]).expect().response().body(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"<title>API Console</title>"), (Matcher)CoreMatchers.containsString((String)"src=\"./?\"")), new Matcher[0]).header("Content-type", "text/html").statusCode(200).when().get("/index.html", new Object[0]);
    }

    @Test
    public void getRamlConsoleNoPath() throws Exception {
        RestAssured.given().port(this.serverPort2.getNumber()).header("Accept", (Object)"application/raml+yaml", new Object[0]).expect().response().body(CoreMatchers.containsString((String)("baseUri: \"http://localhost:" + this.serverPort.getNumber() + "/api\"")), new Matcher[0]).header("Content-type", "application/raml+yaml").statusCode(200).when().get("/", new Object[0]);
    }

    @Test
    public void getRamlConsoleBindAllInterfaces() throws Exception {
        RestAssured.given().port(this.serverPort4.getNumber()).header("Accept", (Object)"application/raml+yaml", new Object[0]).expect().response().body(CoreMatchers.containsString((String)("baseUri: \"http://localhost:" + this.serverPort3.getNumber() + "/api\"")), new Matcher[0]).header("Content-type", "application/raml+yaml").statusCode(200).when().get("/", new Object[0]);
    }

    @Test
    public void consoleEmbeddedNoPath() throws Exception {
        RestAssured.given().port(this.serverPort5.getNumber()).redirects().follow(false).header("Accept", (Object)"text/html", new Object[0]).expect().response().statusCode(301).when().get("/console", new Object[0]);
    }
}

