/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.console;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.ConsoleHandler;
import org.mule.raml.interfaces.model.IRaml;

public class ConsoleRamlUriTestCase {
    private String consoleBaseUri = "http://localhost:8081/console";
    private Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
    private IRaml api = (IRaml)Mockito.mock(IRaml.class);

    public ConsoleRamlUriTestCase() {
        Mockito.when((Object)this.configuration.isParserV2()).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getAppHome()).thenReturn((Object)new File("src/test/resources").getAbsolutePath());
        Mockito.when((Object)this.configuration.getApi()).thenReturn((Object)this.api);
        Mockito.when((Object)this.api.getAllReferences()).thenReturn(Collections.emptyList());
    }

    @Test
    public void apiDirectory() throws Exception {
        Mockito.when((Object)this.configuration.getRaml()).thenReturn((Object)"api.raml");
        Assert.assertThat((Object)this.getApiResourcesRelativePath(this.getConsoleHandler()), (Matcher)Matchers.is((Object)"api/"));
    }

    @Test
    public void nestedApiDirecotry() throws Exception {
        Mockito.when((Object)this.configuration.getRaml()).thenReturn((Object)"subdir/api.raml");
        Assert.assertThat((Object)this.getApiResourcesRelativePath(this.getConsoleHandler()), (Matcher)Matchers.is((Object)"api/subdir/"));
    }

    private ConsoleHandler getConsoleHandler() {
        ConsoleHandler consoleHandler = new ConsoleHandler(this.consoleBaseUri, (AbstractConfiguration)this.configuration);
        consoleHandler.updateRamlUri();
        return consoleHandler;
    }

    private String getApiResourcesRelativePath(ConsoleHandler consoleHandler) throws NoSuchFieldException, IllegalAccessException {
        Field f = consoleHandler.getClass().getDeclaredField("apiResourcesRelativePath");
        f.setAccessible(true);
        return (String)f.get(consoleHandler);
    }
}

