/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.console;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ConsoleApiWithReferencesTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/console/console-api-with-references.xml";
    }

    @Test
    public void console() {
        RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().response().body(CoreMatchers.containsString((String)"<title>API Console</title>"), new Matcher[0]).header("Content-type", "text/html").statusCode(200).when().get("console/index.html", new Object[0]);
    }

    @Test
    public void consoleResource() {
        RestAssured.given().header("Accept", (Object)"text/css", new Object[0]).expect().response().body(CoreMatchers.containsString((String)".CodeMirror"), new Matcher[0]).header("Content-type", "text/css").statusCode(200).when().get("console/styles/api-console-light-theme.css", new Object[0]);
    }

    @Test
    public void apiResources() {
        String[] apiResources;
        for (String resource : apiResources = new String[]{"address.raml", "company-example.json", "partner.raml", "data-type.raml", "library.raml", "company.raml"}) {
            RestAssured.given().header("Accept", (Object)"*/*", new Object[0]).expect().response().statusCode(200).when().get("console/references/" + resource, new Object[0]);
        }
    }

    @Test
    public void consoleEscapeNotFoundResponses() {
        RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().response().body(CoreMatchers.containsString((String)"/&lt;script&gt;alert('hello')%3B&lt;/script&gt;.html"), new Matcher[0]).when().get("console/<script>alert('hello')%3B</script>.html", new Object[0]);
    }
}

