/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.apikit.RestContentTypeParser;

public class RestContentTypeParserTestCase {
    private List<MediaType> parseType(String acceptedHeader) {
        return RestContentTypeParser.parseMediaTypes((String)acceptedHeader);
    }

    @Test
    public void validMediaTypesWithSpaces() throws Exception {
        String acceptedHeader = " application/json, application/xml";
        ArrayList<MediaType> expectedMediaTypes = new ArrayList<MediaType>();
        expectedMediaTypes.add(MediaType.create((String)"application", (String)"json"));
        expectedMediaTypes.add(MediaType.create((String)"application", (String)"xml"));
        List actualMediaTypes = RestContentTypeParser.parseMediaTypes((String)acceptedHeader);
        Assert.assertEquals(expectedMediaTypes, (Object)actualMediaTypes);
    }

    @Test
    public void asterisk() throws Exception {
        List actualMediaTypes = RestContentTypeParser.parseMediaTypes((String)"*");
        Assert.assertTrue((actualMediaTypes.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void asteriskWithPrecedingSpace() throws Exception {
        this.assertAcceptHeader(" *");
    }

    @Test
    public void asteriskWithTrailingSpace() throws Exception {
        this.assertAcceptHeader("* ");
    }

    @Test
    public void slash() throws Exception {
        this.assertAcceptHeader("/");
    }

    @Test
    public void asteriskWithQuality() throws Exception {
        this.assertAcceptHeader("*; q=1");
    }

    @Test
    public void asteriskWithQualityAndPrecedingSpace() throws Exception {
        this.assertAcceptHeader(" *; q=1");
    }

    @Test
    public void alphanumeric() throws Exception {
        this.assertAcceptHeader("asd123*@");
    }

    private void assertAcceptHeader(String acceptedHeader) {
        List actualMediaTypes = RestContentTypeParser.parseMediaTypes((String)acceptedHeader);
        Assert.assertTrue((actualMediaTypes.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void complexMediaTypes() throws Exception {
        String acceptedHeader = "text/html, image/gif, image/jpeg, \u200b*; q=.2, */*; q=.2";
        ArrayList<MediaType> expectedMediaTypes = new ArrayList<MediaType>();
        expectedMediaTypes.add(MediaType.parse((String)"text/html"));
        expectedMediaTypes.add(MediaType.parse((String)"image/gif"));
        expectedMediaTypes.add(MediaType.parse((String)"image/jpeg"));
        expectedMediaTypes.add(MediaType.parse((String)"*/*; q=.2"));
        List actualMediaTypes = RestContentTypeParser.parseMediaTypes((String)acceptedHeader);
        Assert.assertEquals(expectedMediaTypes, (Object)actualMediaTypes);
    }
}

