/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.jayway.restassured.RestAssured;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ContentTypeWithDifferentCasesTestCase
extends FunctionalTestCase {
    private static final String VALID_BODY = "{\"firstname\": \"Juan\", \"lastname\": \"Desi\"}";
    private static final String INVALID_BODY = "{\"firstname\": \"Juan\"}";
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/contenttype/uppercase-content-type-routing-config.xml";
    }

    @Test
    public void endpointWithUpperCaseContentTypeAcceptsUpperCaseContentTypeInRequest() throws Exception {
        RestAssured.given().body(VALID_BODY).contentType("Application/JSON").expect().statusCode(200).when().post("/api/upper", new Object[0]);
    }

    @Test
    public void endpointWithUpperCaseContentTypeAcceptsLowerCaseContentTypeInRequest() throws Exception {
        RestAssured.given().body(VALID_BODY).contentType("application/json").expect().statusCode(200).when().post("/api/upper", new Object[0]);
    }

    @Test
    public void endpointWithLowerCaseContentTypeAcceptsUpperCaseContentTypeInRequest() throws Exception {
        RestAssured.given().body(VALID_BODY).contentType("Application/JSON").expect().statusCode(200).when().post("/api/lower", new Object[0]);
    }

    @Test
    public void endpointWithLowerCaseContentTypeAcceptsLowerCaseContentTypeInRequest() throws Exception {
        RestAssured.given().body(VALID_BODY).contentType("application/json").expect().statusCode(200).when().post("/api/lower", new Object[0]);
    }

    @Test
    public void endpointWithLowerCaseContentTypeAcceptsLowerCaseContentTypeInRequestFailsToValidate() throws Exception {
        RestAssured.given().body(INVALID_BODY).contentType("application/json").expect().statusCode(400).when().post("/api/lower", new Object[0]);
    }

    @Test
    public void endpointWithUpperCaseContentTypeAcceptsLowerCaseContentTypeInRequestFailsToValidate() throws Exception {
        RestAssured.given().body(INVALID_BODY).contentType("application/json").expect().statusCode(400).when().post("/api/upper", new Object[0]);
    }

    @Test
    public void endpointWithUpperCaseContentTypeAcceptsUpperCaseContentTypeInRequestFailsToValidate() throws Exception {
        RestAssured.given().body(INVALID_BODY).contentType("application/JSON").expect().statusCode(400).when().post("/api/upper", new Object[0]);
    }

    @Test
    public void endpointRequestAndFlowContainsContentTypeWithDifferentCasesFailsToValidate() throws Exception {
        RestAssured.given().body(INVALID_BODY).contentType("application/JSON").expect().statusCode(400).when().post("/api/flowDifferentContentTypeCase", new Object[0]);
    }

    @Test
    public void endpointRequestAndFlowContainsContentTypeWithDifferentCases() throws Exception {
        RestAssured.given().body(VALID_BODY).contentType("application/JSON").expect().statusCode(200).when().post("/api/flowDifferentContentTypeCase", new Object[0]);
    }
}

