/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import com.jayway.restassured.RestAssured;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class QueryStringTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("http.port");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/validation/query-string/mule-config.xml";
    }

    @Test
    public void validQueryString() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/simple-type?property=ARG", new Object[0]);
    }

    @Test
    public void emptyQueryString() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/simple-type", new Object[0]);
    }

    @Test
    public void arrayProperty() {
        RestAssured.given().queryParam("property1", new Object[]{"ARG", "USA"}).queryParam("property2", new Object[]{"RUSIA"}).expect().statusCode(200).response().when().get("/api/type-property-array", new Object[0]);
    }

    @Test
    public void arrayPropertyOneItem() {
        RestAssured.given().queryParam("property1", new Object[]{"ARG"}).queryParam("property2", new Object[]{"RUSIA"}).expect().statusCode(200).response().when().get("/api/type-property-array", new Object[0]);
    }

    @Test
    public void requiredProperty() {
        RestAssured.given().expect().statusCode(400).response().when().get("/api/type-property-array", new Object[0]);
    }

    @Test
    public void validObjectProperty() {
        RestAssured.given().expect().statusCode(200).response().when().get("/api/type-property-type?property={\"firstname\": \"Lionel\", \"lastname\": \"Messi\"}", new Object[0]);
    }

    @Test
    public void invalidObjectProperty() {
        RestAssured.given().expect().statusCode(400).response().when().get("/api/type-property-type?property={\"firstname\": \"Lionel\", \"nickname\": \"Messi\"}", new Object[0]);
    }

    @Test
    public void defaultValueProperty() {
        RestAssured.given().queryParam("property", new Object[]{"someValue"}).expect().statusCode(200).response().when().get("/api/default-value-property", new Object[0]);
    }
}

