/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.schema;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.specification.ResponseSpecification;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class EncodingTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigFile() {
        return "org/mule/module/apikit/schema/encoding-config.xml";
    }

    @Test
    public void postXmlW1252on10asStream() throws Exception {
        this.postXmlWindows1252("/api10");
    }

    @Test
    public void postXmlW1252on10asStreamNoCharset() throws Exception {
        this.postXmlWindows1252("/api10", false);
    }

    @Test
    public void postXmlW1252on10asString() throws Exception {
        this.postXmlWindows1252("/api10str");
    }

    @Test
    public void postXmlW1252on10asByteArray() throws Exception {
        this.postXmlWindows1252("/api10byte");
    }

    @Test
    public void postXmlW1252on10asByteArrayNoCharset() throws Exception {
        this.postXmlWindows1252("/api10byte", false);
    }

    @Test
    public void postXmlW1252on08asStream() throws Exception {
        this.postXmlWindows1252("/api08");
    }

    @Test
    public void postXmlW1252on08asStreamNoCharset() throws Exception {
        this.postXmlWindows1252("/api08", false);
    }

    @Test
    public void postXmlW1252on08asString() throws Exception {
        this.postXmlWindows1252("/api08str");
    }

    @Test
    public void postXmlW1252on08asByteArray() throws Exception {
        this.postXmlWindows1252("/api08byte");
    }

    @Test
    public void postXmlW1252on08asByteArrayNoCharset() throws Exception {
        this.postXmlWindows1252("/api08byte", false);
    }

    private void postXmlWindows1252(String api) throws Exception {
        this.postXmlWindows1252(api, true);
    }

    private void postXmlWindows1252(String api, boolean sendCharset) throws Exception {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/mule/module/apikit/schema/payload-windows1252.xml");
        byte[] body = IOUtils.toByteArray((InputStream)inputStream);
        String responseBody = IOUtils.toString((byte[])body, (String)"windows-1252");
        String contentType = "application/xml";
        if (sendCharset) {
            contentType = contentType + ";charset=windows-1252";
        }
        ((ResponseSpecification)RestAssured.given().body(body).header("Content-Type", (Object)contentType, new Object[0]).header("Accept", (Object)"application/xml", new Object[0]).expect().log().everything()).statusCode(200).body(CoreMatchers.is((Object)responseBody), new Matcher[0]).when().post(api + "/testXml", new Object[0]);
    }

    @Test
    public void postJsonUtf16beOn10asStream() throws IOException {
        this.postJsonUtf16be("/api10");
    }

    @Test
    public void postJsonUtf16beOn10asStreamNoCharset() throws IOException {
        this.postJsonUtf16be("/api10", false);
    }

    @Test
    public void postJsonUtf16beOn10asString() throws IOException {
        this.postJsonUtf16be("/api10str");
    }

    @Test
    public void postJsonUtf16beOn10asByteArray() throws IOException {
        this.postJsonUtf16be("/api10byte");
    }

    @Test
    public void postJsonUtf16beOn10asByteArrayNoCharset() throws IOException {
        this.postJsonUtf16be("/api10byte", false);
    }

    @Test
    public void postJsonUtf16beOn08asStream() throws IOException {
        this.postJsonUtf16be("/api08");
    }

    @Test
    public void postJsonUtf16beOn08asStreamNoCharset() throws IOException {
        this.postJsonUtf16be("/api08", false);
    }

    @Test
    public void postJsonUtf16beOn08asString() throws IOException {
        this.postJsonUtf16be("/api08str");
    }

    @Test
    public void postJsonUtf16beOn08asByteArray() throws IOException {
        this.postJsonUtf16be("/api08byte");
    }

    @Test
    public void postJsonUtf16beOn08asByteArrayNoCharset() throws IOException {
        this.postJsonUtf16be("/api08byte", false);
    }

    private void postJsonUtf16be(String api) throws IOException {
        this.postJsonUtf16be(api, true);
    }

    private void postJsonUtf16be(String api, boolean sendCharset) throws IOException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/mule/module/apikit/unicode/diacritics-utf16be.json");
        byte[] body = IOUtils.toByteArray((InputStream)inputStream);
        String contentType = "application/json";
        if (sendCharset) {
            contentType = contentType + ";charset=UTF-16";
        }
        String responseBody = IOUtils.toString((byte[])body, (String)"UTF-16");
        RestAssured.given().body(body).header("Content-Type", (Object)contentType, new Object[0]).expect().statusCode(200).body(CoreMatchers.is((Object)responseBody), new Matcher[0]).when().post(api + "/testJson", new Object[0]);
    }
}

