/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.proxy;

import com.jayway.restassured.RestAssured;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.mule.module.launcher.application.Application;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.infrastructure.deployment.AbstractFakeMuleServerTestCase;

@Ignore
public class ProxyTestCase
extends AbstractFakeMuleServerTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    public void setUp() throws Exception {
        super.setUp();
        RestAssured.port = this.proxyPort.getNumber();
    }

    @Test
    public void proxy() throws Exception {
        this.muleServer.deployAppFromClasspathFolder("org/mule/module/apikit/proxy/proxied-app", "proxied");
        this.muleServer.start();
        this.muleServer.deployAppFromClasspathFolder(this.getProxyAppFolder(), "proxy");
        this.muleServer.assertDeploymentSuccess("proxy");
        this.getOnLeaguesJson();
        this.getOnLeagueJson();
        this.notAcceptable();
        this.notFound();
        this.methodNotAllowed();
        this.getWithRequiredQueryParam();
    }

    @Test
    public void proxyStartStop() throws Exception {
        this.muleServer.deployAppFromClasspathFolder("org/mule/module/apikit/proxy/proxied-app", "proxied");
        this.muleServer.start();
        this.muleServer.deployAppFromClasspathFolder(this.getProxyAppFolder(), "proxy");
        this.muleServer.assertDeploymentSuccess("proxy");
        this.getOnLeaguesJson();
        this.getOnLeagueJson();
        this.notAcceptable();
        this.notFound();
        this.methodNotAllowed();
        this.getWithRequiredQueryParam();
        Application application = this.muleServer.findApplication("proxied");
        application.stop();
        application.start();
        this.getOnLeaguesJson();
        this.getOnLeagueJson();
        this.notAcceptable();
        this.notFound();
        this.methodNotAllowed();
        this.getWithRequiredQueryParam();
    }

    protected String getProxyAppFolder() {
        return "org/mule/module/apikit/proxy/app";
    }

    private void getOnLeaguesJson() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body("name", JUnitMatchers.hasItems((Object[])new String[]{"Liga BBVA", "Premiere League"}), new Object[0]).header("Content-type", CoreMatchers.containsString((String)"application/json")).statusCode(200).when().get("/proxy/leagues", new Object[0]);
    }

    private void getOnLeagueJson() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().body("name", CoreMatchers.is((Object)"Liga BBVA"), new Object[0]).header("Content-type", CoreMatchers.containsString((String)"application/json")).statusCode(200).when().get("/proxy/leagues/1", new Object[0]);
    }

    private void notAcceptable() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/xml", new Object[0]).expect().response().statusCode(406).when().get("/proxy/leagues", new Object[0]);
    }

    private void notFound() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().statusCode(404).when().get("/proxy/leaguess", new Object[0]);
    }

    private void methodNotAllowed() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().statusCode(405).when().patch("/proxy/leagues", new Object[0]);
    }

    private void getWithRequiredQueryParam() {
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).expect().response().statusCode(400).body(CoreMatchers.is((Object)"bad request"), new Matcher[0]).when().get("/proxy/leagues/1/teams", new Object[0]);
        RestAssured.given().header("Accept", (Object)"application/json", new Object[0]).queryParam("limit", new Object[]{"5"}).expect().response().body("name", JUnitMatchers.hasItems((Object[])new String[]{"Atleti", "Elche"}), new Object[0]).header("Content-type", CoreMatchers.containsString((String)"application/json")).statusCode(200).when().get("/proxy/leagues/1/teams", new Object[0]);
    }
}

