/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.console;

import com.jayway.restassured.RestAssured;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class InvalidConsolePath
extends FunctionalTestCase {
    @Rule
    public DynamicPort listenerConsole = new DynamicPort("http.port");
    @Rule
    public DynamicPort secondListenerConsole = new DynamicPort("second.http.port");
    @Rule
    public DynamicPort inboundEndpointConsole = new DynamicPort("inboundEndpointConsole");
    @Rule
    public DynamicPort secondInboundEndpointConsole = new DynamicPort("secondInboundEndpointConsole");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/console/invalid-console-path.xml";
    }

    @Test
    public void getConsoleWithInvalidPathWithListener() throws Exception {
        RestAssured.port = this.listenerConsole.getNumber();
        RestAssured.given().expect().statusCode(500).when().get("/console/", new Object[0]);
    }

    @Test
    public void getConsoleWithInboundEndpoint() throws Exception {
        RestAssured.port = this.inboundEndpointConsole.getNumber();
        RestAssured.given().expect().statusCode(200).when().get("/console/", new Object[0]);
    }

    @Test
    public void getSecondConsoleWithInvalidPathWithListener() throws Exception {
        RestAssured.port = this.secondListenerConsole.getNumber();
        RestAssured.given().expect().statusCode(500).when().get("/console", new Object[0]);
    }

    @Test
    public void getSecondConsoleWithInboundEndpoint() throws Exception {
        RestAssured.port = this.secondInboundEndpointConsole.getNumber();
        RestAssured.given().expect().statusCode(200).when().get("/console", new Object[0]);
    }
}

