/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.assets;

import com.jayway.restassured.RestAssured;
import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mule.module.apikit.util.FunctionalAppDeployTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ApiDirTestCase
extends FunctionalAppDeployTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public DynamicPort serverPort2 = new DynamicPort("serverPort2");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    @Override
    public void doSetUp() throws Exception {
        RestAssured.port = this.serverPort2.getNumber();
        super.doSetUp();
    }

    @Test
    public void ramlApi() throws Exception {
        File appDir = new File("src/test/resources", "org/mule/module/apikit/assets");
        String appName = "ramlApi";
        this.deployExplodedApp(appDir, appName);
        this.deploymentService.start();
        this.assertApplicationDeploymentSuccess(this.applicationDeploymentListener, appName);
        this.assertRaml();
        this.assertConsole();
    }

    private void assertRaml() throws Exception {
        RestAssured.given().header("Accept", (Object)"application/raml+yaml", new Object[0]).expect().response().body(CoreMatchers.containsString((String)("baseUri: http://localhost:" + this.serverPort.getValue() + "/api")), new Matcher[]{CoreMatchers.containsString((String)"!include example.json")}).header("Content-type", "application/raml+yaml").statusCode(200).when().get("/api/?raml", new Object[0]);
    }

    private void assertConsole() throws Exception {
        RestAssured.given().header("Accept", (Object)"text/html", new Object[0]).expect().response().body(CoreMatchers.containsString((String)"src=\"api/?raml\""), new Matcher[0]).header("Content-type", "text/html").statusCode(200).when().get("/", new Object[0]);
    }
}

