/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import org.junit.Assert;
import org.junit.Test;
import org.mule.module.apikit.UrlUtils;

public class UrlUtilsTestCase {
    String ramlRelativeUri = "#%RAML 1.0\ntitle: Admin\nversion: 1.0\nbaseUri: /api\n";
    String ramlFullUri = "#%RAML 1.0\ntitle: Admin\nversion: 1.0\nbaseUri: http://localhost:9090/api\n";
    String ramlRelativeTwoDotsUri = "#%RAML 1.0\ntitle: Admin\nversion: 1.0\nbaseUri: ../api\n";
    String ramlRelativeWithoutSlashUri = "#%RAML 1.0\ntitle: Admin\nversion: 1.0\nbaseUri: api\n";

    @Test
    public void replaceRelativeBaseUriWithFull() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlRelativeUri, (String)"http://localhost:8081/api");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: http://localhost:8081/api"));
    }

    @Test
    public void replaceRelativeBaseUriWithRelative() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlRelativeUri, (String)"/newapi");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: /newapi"));
    }

    @Test
    public void replaceFullBaseUriWithFull() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlFullUri, (String)"http://localhost:8081/api");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: http://localhost:8081/api"));
    }

    @Test
    public void replaceFullBaseUriWithRelative() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlFullUri, (String)"/newapi");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: /newapi"));
    }

    @Test
    public void replaceFullBaseUriWithRelativeTwoDots() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlFullUri, (String)"../api");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: ../api"));
    }

    @Test
    public void replaceFullBaseUriWithRelativeWithoutSlash() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlFullUri, (String)"api");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: api"));
    }

    @Test
    public void replaceRelativeBaseUriWithRelativeTwoDots() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlRelativeUri, (String)"../api");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: ../api"));
    }

    @Test
    public void replaceRelativeBaseUriWithRelativeWithoutSlash() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlRelativeUri, (String)"api");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: api"));
    }

    @Test
    public void replaceRelativeTwoDotsBaseUriWithFull() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlRelativeTwoDotsUri, (String)"http://hola.com/api");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: http://hola.com/api"));
    }

    @Test
    public void replaceRelativeTwoDotsBaseUriWithRelative() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlRelativeTwoDotsUri, (String)"/api");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: /api"));
    }

    @Test
    public void replaceRelativeTwoDotsBaseUriWithRelativeTwoDots() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlRelativeTwoDotsUri, (String)"../api2");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: ../api2"));
    }

    @Test
    public void replaceRelativeTwoDotsBaseUriWithRelativeWithoutSlash() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlRelativeTwoDotsUri, (String)"api2");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: api2"));
    }

    @Test
    public void replaceRelativeWithoutSlashBaseUriWithRelativeWithoutSlash() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlRelativeWithoutSlashUri, (String)"api2");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: api2"));
    }

    @Test
    public void replaceRelativeWithoutSlashBaseUriWithFull() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlRelativeWithoutSlashUri, (String)"http://hello.com/api2");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: http://hello.com/api2"));
    }

    @Test
    public void replaceRelativeWithoutSlashBaseUriWithRelative() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlRelativeWithoutSlashUri, (String)"/api2");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: /api2"));
    }

    @Test
    public void replaceRelativeWithoutSlashBaseUriWithRelativeTwoDots() {
        String newRaml = UrlUtils.replaceBaseUri((String)this.ramlRelativeWithoutSlashUri, (String)"../api2");
        Assert.assertTrue((boolean)newRaml.contains("baseUri: ../api2"));
    }
}

