/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.jayway.restassured.RestAssured;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class RequestSchemaValidationTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("http.port");

    public int getTestTimeoutSecs() {
        return 6000;
    }

    protected void doSetUp() throws Exception {
        RestAssured.port = this.serverPort.getNumber();
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "org/mule/module/apikit/schema/request-schema-validation/mule-config.xml";
    }

    @Test
    public void requestIn08() {
        RestAssured.given().body("{ \"size\": 1, \"email\": \"asas.dasd@mulesoft.com\", \"name\": \"Awesome Tshirt\", \"address1\": \"Mulesoft Inc\", \"address2\": \"GEARY STREET\", \"city\": \"SFO\", \"stateOrProvince\": \"CA\", \"postalCode\": \"94583\", \"country\": \"USA\" }").contentType("application/json").expect().statusCode(400).response().body(Matchers.containsString((String)"/size"), new Matcher[0]).header("Content-Type", Matchers.is((Object)"application/json")).when().post("/api/orderTshirt", new Object[0]);
    }

    @Test
    public void showAllSchemaValidationErrors() {
        RestAssured.given().body("{ \"size\": 90 }").contentType("application/json").expect().statusCode(400).response().body(Matchers.containsString((String)"object has missing required properties"), new Matcher[0]).body(Matchers.containsString((String)"error: instance type (integer) does not match any allowed primitive type"), new Matcher[0]).header("Content-Type", Matchers.is((Object)"application/json")).when().post("/api/orderTshirt", new Object[0]);
    }
}

