/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.collect.Lists;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.message.DefaultExceptionPayload;
import org.mule.module.apikit.MappingExceptionListener;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.exception.MuleRestException;

public class MappingExceptionListenerTestCase {
    private MappingExceptionListener listener;

    @Before
    public void setup() {
        this.listener = new MappingExceptionListener();
    }

    @Test
    public void testExceptionListenerAcceptsInitializedException() throws InitialisationException {
        MuleRestException exception = new MuleRestException();
        this.listener.setExceptions((List)Lists.newArrayList((Object[])new String[]{exception.getClass().getName()}));
        this.listener.setMuleContext(this.mockMuleContext());
        this.listener.initialise();
        boolean accepted = this.listener.accept(this.mockMuleEventWithException((Exception)exception));
        Assert.assertTrue((boolean)accepted);
    }

    @Test
    public void testExceptionListenerDoesNotAcceptNotInitializedException() throws InitialisationException {
        MuleRestException exception = new MuleRestException();
        this.listener.setExceptions((List)Lists.newArrayList((Object[])new String[]{exception.getClass().getName()}));
        this.listener.setMuleContext(this.mockMuleContext());
        this.listener.initialise();
        boolean accepted = this.listener.accept(this.mockMuleEventWithException(new RuntimeException()));
        Assert.assertFalse((boolean)accepted);
    }

    @Test(expected=ApikitRuntimeException.class)
    public void testUnknownExceptionMappingFailsDuringInitialization() throws InitialisationException {
        this.listener.setExceptions((List)Lists.newArrayList((Object[])new String[]{"unknownException"}));
        this.listener.setMuleContext(this.mockMuleContext());
        this.listener.initialise();
    }

    private MuleContext mockMuleContext() {
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getExecutionClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        return muleContext;
    }

    private MuleEvent mockMuleEventWithException(Exception exception) {
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleMessage muleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)muleEvent.getMessage()).thenReturn((Object)muleMessage);
        Mockito.when((Object)muleMessage.getExceptionPayload()).thenReturn((Object)new DefaultExceptionPayload((Throwable)exception));
        return muleEvent;
    }
}

