/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.Router;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class InvalidRamlTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void invalidRaml() throws Exception {
        try {
            this.validateRaml("org/mule/module/apikit/invalid-config.yaml");
            junit.framework.Assert.fail();
        }
        catch (ApikitRuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"errors found: 2"));
        }
    }

    private Router validateRaml(String ramlPath) throws InitialisationException {
        Configuration config = new Configuration();
        config.setMuleContext(muleContext);
        config.setRaml(ramlPath);
        config.initialise();
        Router router = new Router();
        router.setConfig(config);
        return router;
    }

    @Test
    public void invalidRamlLocation() throws Exception {
        try {
            this.validateRaml("invalidRamlLocation.raml");
            junit.framework.Assert.fail();
        }
        catch (ApikitRuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"errors found: 1"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"RAML resource not found --  file: invalidRamlLocation.raml"));
        }
    }
}

